/*
 * Decompiled with CFR 0.152.
 */
package org.multihelp;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreePath;
import org.multihelp.FileTreeReader;
import org.multihelp.file.ExternalNode;
import org.multihelp.file.FileNode;

public class HelpViewer
extends JEditorPane {
    private static final long serialVersionUID = 2L;
    protected FileTreeReader fileSource;
    protected FileNode currentNode;
    private MouseListener listener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            if (e.getClickCount() > 0 && HelpViewer.this.fileSource.getSelectionCount() > 0 && (path = HelpViewer.this.fileSource.getLeadSelectionPath()) != null) {
                FileNode node;
                HelpViewer.this.currentNode = node = (FileNode)path.getLastPathComponent();
                node.setPage(HelpViewer.this.reflect());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    protected HyperlinkListener urlHook = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent arg0) {
            try {
                if (arg0.getEventType().toString().equals("ACTIVATED")) {
                    FileNode node = HelpViewer.this.currentNode.resolveURL(arg0.getURL());
                    if (node == null) {
                        node = new ExternalNode(arg0.getURL());
                    }
                    HelpViewer.this.currentNode = node;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, String.valueOf(e.getMessage()) + e.getStackTrace(), "ERROR", 0);
            }
        }
    };

    public HelpViewer() {
    }

    protected HelpViewer reflect() {
        return this;
    }

    public HelpViewer(FileTreeReader fileSource) {
        this.fileSource = fileSource;
        this.setEditable(false);
        fileSource.addMouseListener(this.listener);
        try {
            FileNode n;
            this.currentNode = n = (FileNode)fileSource.getModel().getRoot();
            n.setPage(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getStackTrace(), "ERROR", 0);
        }
        this.addHyperlinkListener(this.urlHook);
    }
}

