/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioSamples {
    protected String unique_ID;
    protected double[] samples;
    protected double[][] channel_samples;
    protected AudioFormat audio_format;

    public AudioSamples(File audio_file, String unique_identifier, boolean normalize_if_clipped) throws Exception {
        if (!audio_file.exists()) {
            throw new Exception("File " + audio_file.getName() + " does not exist.");
        }
        if (audio_file.isDirectory()) {
            throw new Exception("File " + audio_file.getName() + " is a directory.");
        }
        AudioInputStream audio_input_stream = null;
        try {
            audio_input_stream = AudioSystem.getAudioInputStream(audio_file);
        }
        catch (UnsupportedAudioFileException ex) {
            throw new Exception("File " + audio_file.getName() + " has an unsupported audio format.");
        }
        catch (IOException ex) {
            throw new Exception("File " + audio_file.getName() + " is not readable.");
        }
        AudioInputStream converted_audio = AudioMethods.getConvertedAudioStream(audio_input_stream);
        this.channel_samples = AudioMethods.extractSampleValues(converted_audio);
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(this.channel_samples);
        if (this.channel_samples.length == 1) {
            this.channel_samples = null;
        }
        this.audio_format = converted_audio.getFormat();
        this.unique_ID = unique_identifier;
        if (normalize_if_clipped) {
            this.normalizeIfClipped();
        }
        converted_audio.close();
    }

    public AudioSamples(AudioInputStream audio_input_stream, String unique_identifier, boolean normalize_if_clipped) throws Exception {
        if (audio_input_stream == null) {
            throw new Exception("Given AudioInputStream is empty.");
        }
        this.unique_ID = unique_identifier;
        AudioInputStream converted_audio = AudioMethods.getConvertedAudioStream(audio_input_stream);
        this.channel_samples = AudioMethods.extractSampleValues(converted_audio);
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(this.channel_samples);
        if (this.channel_samples.length == 1) {
            this.channel_samples = null;
        }
        this.audio_format = converted_audio.getFormat();
        if (normalize_if_clipped) {
            this.normalizeIfClipped();
        }
        converted_audio.close();
    }

    public AudioSamples(double[][] audio_samples, AudioFormat audio_format, String unique_identifier, boolean normalize_if_clipped) throws Exception {
        if (audio_samples == null) {
            throw new Exception("Given audio samples array is empty.");
        }
        int chan = 0;
        while (chan < audio_samples.length) {
            if (audio_samples[chan] == null) {
                throw new Exception("One or more channels of given audio samples array is empty.");
            }
            ++chan;
        }
        int number_samples = audio_samples[0].length;
        int chan2 = 0;
        while (chan2 < audio_samples.length) {
            if (audio_samples[chan2].length != number_samples) {
                throw new Exception("Different channels of given audio samples array have a\ndifferent number of samples.");
            }
            ++chan2;
        }
        if (audio_format == null) {
            throw new Exception("Null audio format specified for samples.");
        }
        if (audio_format.getChannels() != audio_samples.length) {
            throw new Exception("The specified samples have " + audio_samples.length + " channels but\n" + "the specified audio format has " + audio_format.getChannels() + " channels.\n" + "These must be the same.");
        }
        this.unique_ID = unique_identifier;
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(audio_samples);
        this.channel_samples = (double[][])(audio_samples.length == 1 ? null : DSPMethods.getCopyOfSamples(audio_samples));
        this.audio_format = AudioMethods.getConvertedAudioFormat(audio_format);
        if (normalize_if_clipped) {
            this.normalizeIfClipped();
        }
    }

    public AudioSamples(double[][] audio_samples, float sampling_rate, String unique_identifier, boolean normalize_if_clipped) throws Exception {
        if (audio_samples == null) {
            throw new Exception("Given audio samples array is empty.");
        }
        int chan = 0;
        while (chan < audio_samples.length) {
            if (audio_samples[chan] == null) {
                throw new Exception("One or more channels of given audio samples array is empty.");
            }
            ++chan;
        }
        int number_samples = audio_samples[0].length;
        int chan2 = 0;
        while (chan2 < audio_samples.length) {
            if (audio_samples[chan2].length != number_samples) {
                throw new Exception("Different channels of given audio samples array have a\ndifferent number of samples.");
            }
            ++chan2;
        }
        this.unique_ID = unique_identifier;
        this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(audio_samples);
        this.channel_samples = (double[][])(audio_samples.length == 1 ? null : DSPMethods.getCopyOfSamples(audio_samples));
        this.audio_format = this.getDefaultAudioFormat(sampling_rate);
        if (normalize_if_clipped) {
            this.normalizeIfClipped();
        }
    }

    public AudioSamples getCopyOfAudioSamples() throws Exception {
        int i;
        String new_unique_ID = null;
        if (new_unique_ID != null) {
            // empty if block
        }
        Object new_channel_samples = null;
        if (this.channel_samples != null) {
            new_channel_samples = new double[this.channel_samples.length][];
            i = 0;
            while (i < ((double[][])new_channel_samples).length) {
                new_channel_samples[i] = new double[this.channel_samples[i].length];
                int j = 0;
                while (j < new_channel_samples[i].length) {
                    new_channel_samples[i][j] = this.channel_samples[i][j];
                    ++j;
                }
                ++i;
            }
        } else {
            new_channel_samples = new double[1][this.samples.length];
            i = 0;
            while (i < this.samples.length) {
                new_channel_samples[0][i] = this.samples[i];
                ++i;
            }
        }
        AudioFormat new_audio_format = null;
        if (this.audio_format != null) {
            new_audio_format = new AudioFormat(this.audio_format.getEncoding(), this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), this.audio_format.getChannels(), this.audio_format.getFrameSize(), this.audio_format.getFrameRate(), this.audio_format.isBigEndian());
        }
        return new AudioSamples((double[][])new_channel_samples, new_audio_format, new_unique_ID, false);
    }

    public String getRecordingInfo() {
        String return_string = AudioMethods.getAudioFormatData(this.audio_format);
        String number_samples = String.valueOf(this.getNumberSamplesPerChannel()) + " samples\n";
        String duration = String.valueOf(this.getDuration()) + " seconds\n";
        String max_sample_value = String.valueOf(this.getMaximumAmplitude()) + "\n";
        return_string = String.valueOf(return_string) + new String("SAMPLES PER CHANNEL: " + number_samples);
        return_string = String.valueOf(return_string) + new String("DURATION: " + duration);
        return_string = String.valueOf(return_string) + new String("MAX SIGNAL AMPLITUDE: " + max_sample_value);
        return return_string;
    }

    public String getUniqueIdentifier() {
        return this.unique_ID;
    }

    public AudioFormat getAudioFormat() {
        return this.audio_format;
    }

    public float getSamplingRate() {
        return this.audio_format.getSampleRate();
    }

    public double getSamplingRateAsDouble() {
        return new Float(this.audio_format.getSampleRate()).doubleValue();
    }

    public int getNumberSamplesPerChannel() {
        return this.samples.length;
    }

    public double getDuration() {
        return this.convertSampleIndexToTime(this.samples.length - 1);
    }

    public int getNumberChannels() {
        if (this.channel_samples == null) {
            return 1;
        }
        return this.channel_samples.length;
    }

    public double[] getSamplesMixedDown() {
        return this.samples;
    }

    public double[] getSamplesMixedDown(int start_sample, int end_sample) throws Exception {
        if (start_sample < 0) {
            throw new Exception("Requested audio starting at sample " + start_sample + "\nStart sample indice must be 0 or greater.");
        }
        if (end_sample >= this.samples.length) {
            throw new Exception("Requested audio ending at sample " + end_sample + "\nA total of " + this.samples.length + "samples are present." + "\nRequested ending sample indice must be less than this.");
        }
        if (start_sample >= end_sample) {
            throw new Exception("Requested audio starting at sample " + start_sample + " and ending at sample " + end_sample + ".\n" + "Requested start sample indice must be less than requested" + "\nend sample indice.");
        }
        int number_samples = end_sample - start_sample;
        double[] sample_segment = new double[number_samples];
        int samp = start_sample;
        while (samp <= end_sample) {
            sample_segment[samp - start_sample] = this.samples[samp];
            ++samp;
        }
        return sample_segment;
    }

    public double[] getSamplesMixedDown(double start_time, double end_time) throws Exception {
        int start_sample = this.convertTimeToSampleIndex(start_time);
        int end_sample = this.convertTimeToSampleIndex(end_time);
        return this.getSamplesMixedDown(start_sample, end_sample);
    }

    public double[][] getSampleWindowsMixedDown(int window_size) throws Exception {
        if (window_size < 1) {
            throw new Exception("Window size of " + window_size + " specified.\n" + "This value must be above 0.");
        }
        int number_windows = this.samples.length / window_size;
        if (this.samples.length % window_size != 0) {
            ++number_windows;
        }
        double[][] windowed_samples = new double[number_windows][window_size];
        int win = 0;
        while (win < number_windows) {
            int samp;
            if (win != number_windows - 1) {
                samp = 0;
                while (samp < window_size) {
                    windowed_samples[win][samp] = this.samples[win * window_size + samp];
                    ++samp;
                }
            } else {
                samp = 0;
                while (samp < window_size) {
                    windowed_samples[win][samp] = win * window_size + samp < this.samples.length ? this.samples[win * window_size + samp] : 0.0;
                    ++samp;
                }
            }
            ++win;
        }
        return windowed_samples;
    }

    public double[][] getSampleWindowsMixedDown(double window_duration) throws Exception {
        int window_size = this.convertTimeToSampleIndex(window_duration);
        return this.getSampleWindowsMixedDown(window_size);
    }

    public AudioInputStream getAudioInputStreamMixedDown() throws Exception {
        AudioFormat mixed_down_audio_format = new AudioFormat(this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), 1, true, this.audio_format.isBigEndian());
        double[][] samples_to_convert = new double[][]{this.samples};
        AudioInputStream audio_input_stream = AudioMethods.convertToAudioInputStream(samples_to_convert, mixed_down_audio_format);
        return audio_input_stream;
    }

    public AudioInputStream getAudioInputStreamMixedDown(int start_sample, int end_sample) throws Exception {
        AudioFormat mixed_down_audio_format = new AudioFormat(this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), 1, true, this.audio_format.isBigEndian());
        double[] sample_portion = this.getSamplesMixedDown(start_sample, end_sample);
        double[][] samples_to_convert = new double[][]{sample_portion};
        AudioInputStream audio_input_stream = AudioMethods.convertToAudioInputStream(samples_to_convert, mixed_down_audio_format);
        return audio_input_stream;
    }

    public AudioInputStream getAudioInputStreamMixedDown(double start_time, double end_time) throws Exception {
        AudioFormat mixed_down_audio_format = new AudioFormat(this.audio_format.getSampleRate(), this.audio_format.getSampleSizeInBits(), 1, true, this.audio_format.isBigEndian());
        double[] sample_portion = this.getSamplesMixedDown(start_time, end_time);
        double[][] samples_to_convert = new double[][]{sample_portion};
        AudioInputStream audio_input_stream = AudioMethods.convertToAudioInputStream(samples_to_convert, mixed_down_audio_format);
        return audio_input_stream;
    }

    public double[][] getSamplesChannelSegregated() {
        if (this.channel_samples == null) {
            double[][] formatted_samples = new double[][]{this.samples};
            return formatted_samples;
        }
        return this.channel_samples;
    }

    public double[][] getSamplesChannelSegregated(int start_sample, int end_sample) throws Exception {
        if (start_sample < 0) {
            throw new Exception("Requested audio starting at sample " + start_sample + "\nStart sample indice must be 0 or greater.");
        }
        if (end_sample >= this.samples.length) {
            throw new Exception("Requested audio ending at sample " + end_sample + "\nA total of " + this.samples.length + "samples are present." + "\nRequested ending sample indice must be less than this.");
        }
        if (start_sample >= end_sample) {
            throw new Exception("Requested audio starting at sample " + start_sample + " and ending at sample " + end_sample + ".\n" + "Requested start sample indice must be less than requested" + "\nend sample indice.");
        }
        int number_samples = end_sample - start_sample + 1;
        if (this.channel_samples == null) {
            double[][] sample_segment = new double[1][number_samples];
            int samp = start_sample;
            while (samp <= end_sample) {
                sample_segment[0][samp - start_sample] = this.samples[samp];
                ++samp;
            }
            return sample_segment;
        }
        double[][] sample_segment = new double[this.channel_samples.length][number_samples];
        int chan = 0;
        while (chan < this.channel_samples.length) {
            int samp = start_sample;
            while (samp <= end_sample) {
                sample_segment[chan][samp - start_sample] = this.channel_samples[chan][samp];
                ++samp;
            }
            ++chan;
        }
        return sample_segment;
    }

    public double[][] getSamplesChannelSegregated(double start_time, double end_time) throws Exception {
        int start_sample = this.convertTimeToSampleIndex(start_time);
        int end_sample = this.convertTimeToSampleIndex(end_time);
        return this.getSamplesChannelSegregated(start_sample, end_sample);
    }

    public double[][][] getSampleWindowsChannelSegregated(int window_size) throws Exception {
        if (this.channel_samples == null) {
            double[][][] windowed_samples = new double[][][]{this.getSampleWindowsMixedDown(window_size)};
            return windowed_samples;
        }
        if (window_size < 1) {
            throw new Exception("Window size of " + window_size + " specified.\n" + "This value must be above 0.");
        }
        int number_windows = this.samples.length / window_size;
        if (this.samples.length % window_size != 0) {
            ++number_windows;
        }
        double[][][] windowed_samples = new double[this.channel_samples.length][number_windows][window_size];
        int chan = 0;
        while (chan < this.channel_samples.length) {
            int win = 0;
            while (win < number_windows) {
                int samp;
                if (win != number_windows - 1) {
                    samp = 0;
                    while (samp < window_size) {
                        windowed_samples[chan][win][samp] = this.channel_samples[chan][win * window_size + samp];
                        ++samp;
                    }
                } else {
                    samp = 0;
                    while (samp < window_size) {
                        windowed_samples[chan][win][samp] = win * window_size + samp < this.samples.length ? this.channel_samples[chan][win * window_size + samp] : 0.0;
                        ++samp;
                    }
                }
                ++win;
            }
            ++chan;
        }
        return windowed_samples;
    }

    public double[][][] getSampleWindowsChannelSegregated(double window_duration) throws Exception {
        int window_size = this.convertTimeToSampleIndex(window_duration);
        return this.getSampleWindowsChannelSegregated(window_size);
    }

    public AudioInputStream getAudioInputStreamChannelSegregated() throws Exception {
        double[][] samples_to_convert = this.getSamplesChannelSegregated();
        AudioInputStream audio_input_stream = AudioMethods.convertToAudioInputStream(samples_to_convert, this.audio_format);
        return audio_input_stream;
    }

    public AudioInputStream getAudioInputStreamChannelSegregated(int start_sample, int end_sample) throws Exception {
        double[][] samples_to_convert = this.getSamplesChannelSegregated(start_sample, end_sample);
        AudioInputStream audio_input_stream = AudioMethods.convertToAudioInputStream(samples_to_convert, this.audio_format);
        return audio_input_stream;
    }

    public AudioInputStream getAudioInputStreamChannelSegregated(double start_time, double end_time) throws Exception {
        double[][] samples_to_convert = this.getSamplesChannelSegregated(start_time, end_time);
        AudioInputStream audio_input_stream = AudioMethods.convertToAudioInputStream(samples_to_convert, this.audio_format);
        return audio_input_stream;
    }

    public void saveAudio(File save_file, boolean multi_channel, AudioFileFormat.Type save_file_type, boolean normalize_if_clipped) throws Exception {
        if (save_file == null) {
            throw new Exception("No file provided to save to.");
        }
        if (normalize_if_clipped) {
            this.normalizeIfClipped();
        }
        AudioInputStream audio_input_stream = null;
        audio_input_stream = multi_channel ? this.getAudioInputStreamChannelSegregated() : this.getAudioInputStreamMixedDown();
        if (save_file_type == null) {
            save_file_type = AudioFileFormat.Type.WAVE;
        }
        if (save_file.exists()) {
            save_file.delete();
        }
        AudioSystem.write(audio_input_stream, save_file_type, save_file);
    }

    public void normalizeIfClipped() {
        if (this.checkMixedDownSamplesForClipping() > 0.0) {
            this.normalizeMixedDownSamples();
        }
        if (this.checkChannelSegregatedSamplesForClipping() > 0.0) {
            this.normalizeChannelSegretatedSamples();
        }
    }

    public double getMaximumAmplitude() {
        double max_amplitude = 0.0;
        if (this.channel_samples != null) {
            int chan = 0;
            while (chan < this.channel_samples.length) {
                int samp = 0;
                while (samp < this.channel_samples[chan].length) {
                    if (Math.abs(this.channel_samples[chan][samp]) > max_amplitude) {
                        max_amplitude = Math.abs(this.channel_samples[chan][samp]);
                    }
                    ++samp;
                }
                ++chan;
            }
        } else {
            int samp = 0;
            while (samp < this.samples.length) {
                if (Math.abs(this.samples[samp]) > max_amplitude) {
                    max_amplitude = Math.abs(this.samples[samp]);
                }
                ++samp;
            }
        }
        return max_amplitude;
    }

    public double checkMixedDownSamplesForClipping() {
        double max_difference = -1.0;
        int samp = 0;
        while (samp < this.samples.length) {
            double difference;
            if (Math.abs(this.samples[samp]) > 1.0 && (difference = Math.abs(this.samples[samp]) - 1.0) > max_difference) {
                max_difference = difference;
            }
            ++samp;
        }
        return max_difference;
    }

    public double checkChannelSegregatedSamplesForClipping() {
        double max_difference = -1.0;
        if (this.channel_samples != null) {
            int chan = 0;
            while (chan < this.channel_samples.length) {
                int samp = 0;
                while (samp < this.channel_samples[chan].length) {
                    double difference;
                    if (Math.abs(this.channel_samples[chan][samp]) > 1.0 && (difference = Math.abs(this.channel_samples[chan][samp]) - 1.0) > max_difference) {
                        max_difference = difference;
                    }
                    ++samp;
                }
                ++chan;
            }
        } else {
            max_difference = this.checkMixedDownSamplesForClipping();
        }
        return max_difference;
    }

    public void normalizeMixedDownSamples() {
        this.samples = DSPMethods.normalizeSamples(this.samples);
    }

    public void normalizeChannelSegretatedSamples() {
        if (this.channel_samples != null) {
            this.channel_samples = DSPMethods.normalizeSamples(this.channel_samples);
        } else {
            this.normalizeMixedDownSamples();
        }
    }

    public void normalize() {
        this.normalizeChannelSegretatedSamples();
        if (this.channel_samples != null) {
            this.normalizeMixedDownSamples();
        }
    }

    public void setSamples(double[][] new_samples) throws Exception {
        if (new_samples == null) {
            throw new Exception("An empty set of samples provided.");
        }
        int number_samples = -1;
        int chan = 0;
        while (chan < new_samples.length) {
            if (new_samples[chan] == null) {
                throw new Exception("Channel " + chan + " of the given samples is empty.");
            }
            if (number_samples != -1 && number_samples != new_samples[chan].length) {
                throw new Exception("Different channels have different numbers of samples.");
            }
            number_samples = new_samples[chan].length;
            ++chan;
        }
        if (this.channel_samples == null) {
            if (new_samples.length != 1) {
                throw new Exception("Given samples have " + new_samples.length + " channels.\n" + "Only one channel should be present.");
            }
            this.samples = new double[number_samples];
            int samp = 0;
            while (samp < this.samples.length) {
                this.samples[samp] = new_samples[0][samp];
                ++samp;
            }
        } else {
            if (new_samples.length != this.channel_samples.length) {
                throw new Exception("Given samples have " + new_samples.length + " channels.\n" + this.channel_samples.length + " channel should be present.");
            }
            this.channel_samples = new double[new_samples.length][number_samples];
            chan = 0;
            while (chan < this.channel_samples.length) {
                int samp = 0;
                while (samp < this.channel_samples[chan].length) {
                    this.channel_samples[chan][samp] = new_samples[chan][samp];
                    ++samp;
                }
                ++chan;
            }
            this.samples = DSPMethods.getSamplesMixedDownIntoOneChannel(this.channel_samples);
        }
    }

    private AudioFormat getDefaultAudioFormat(float sampling_rate) {
        int bit_depth = 16;
        boolean signed = true;
        boolean big_endian = true;
        int channels = 1;
        if (this.channel_samples == null) {
            channels = this.channel_samples.length;
        }
        return new AudioFormat(sampling_rate, bit_depth, channels, signed, big_endian);
    }

    private double convertSampleIndexToTime(int sample_index) {
        if (sample_index < 0) {
            sample_index = 0;
        } else if (sample_index >= this.samples.length) {
            sample_index = this.samples.length - 1;
        }
        float time = (float)this.samples.length / this.audio_format.getSampleRate();
        return new Float(time).doubleValue();
    }

    private int convertTimeToSampleIndex(double time) {
        int sample_index = (int)(time * (double)this.audio_format.getSampleRate());
        if (sample_index < 0) {
            return 0;
        }
        if (sample_index >= this.samples.length) {
            return this.samples.length - 1;
        }
        return sample_index;
    }
}

