/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.XMLParsers.FileFilterXML;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.FeatureSelectorTableModel;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class SaveAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private FeatureSelectorTableModel fstm_;
    private JFileChooser save_file_chooser = null;
    private Controller controller;

    public SaveAction(Controller c, FeatureSelectorTableModel fstm) {
        super("Save Settings...");
        this.fstm_ = fstm;
        this.controller = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.save_file_chooser == null) {
            this.save_file_chooser = new JFileChooser();
            this.save_file_chooser.setCurrentDirectory(new File("."));
            this.save_file_chooser.setFileFilter(new FileFilterXML());
        }
        String path = null;
        int dialog_result = this.save_file_chooser.showSaveDialog(null);
        if (dialog_result == 0) {
            int overwrite;
            File to_save_to = this.save_file_chooser.getSelectedFile();
            path = to_save_to.getPath();
            String ext = StringMethods.getExtension(path);
            if (ext == null) {
                path = String.valueOf(path) + ".xml";
                to_save_to = new File(path);
            } else if (!ext.equals(".xml")) {
                path = String.valueOf(StringMethods.removeExtension(path)) + ".xml";
                to_save_to = new File(path);
            }
            if (to_save_to.exists() && (overwrite = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                path = null;
            }
            File dest = new File(path);
            String winSize = this.window_length_text_field.getText();
            String winOverlap = this.window_overlap_fraction_text_field.getText();
            double sampleRate = this.controller.samplingRateAction.getSamplingRate();
            boolean normalise = this.controller.normalise.isSelected();
            boolean perWindow = this.save_window_features_check_box.isSelected();
            boolean overall = this.save_overall_file_featurese_check_box.isSelected();
            try {
                int j;
                FileWriter fw = new FileWriter(dest);
                String sep = System.getProperty("line.separator");
                fw.write("<?xml version=\"1.0\"?>" + sep);
                fw.write("<!DOCTYPE save_settings [" + sep);
                fw.write("\t<!ELEMENT save_settings (windowSize,windowOverlap,samplingRate,normalise,perWindowStats,overallStats,outputType,feature+,aggregator+)>" + sep);
                fw.write("\t<!ELEMENT windowSize (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT windowOverlap (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT samplingRate (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT normalise (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT perWindowStats (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT overallStats (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT outputType (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT feature (name,active,attribute*)>" + sep);
                fw.write("\t<!ELEMENT name (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT active (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT attribute (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT aggregator (aggregatorName, aggregatorFeature*, aggregatorAttribute*)>" + sep);
                fw.write("\t<!ELEMENT aggregatorName (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT aggregatorFeature (#PCDATA)>" + sep);
                fw.write("\t<!ELEMENT aggregatorAttribute (#PCDATA)>" + sep);
                fw.write("]>" + sep);
                fw.write(sep);
                fw.write("<save_settings>" + sep);
                fw.write("\t<windowSize>" + winSize + "</windowSize>" + sep);
                fw.write("\t<windowOverlap>" + winOverlap + "</windowOverlap>" + sep);
                fw.write("\t<samplingRate>" + sampleRate + "</samplingRate>" + sep);
                fw.write("\t<normalise>" + normalise + "</normalise>" + sep);
                fw.write("\t<perWindowStats>" + perWindow + "</perWindowStats>" + sep);
                fw.write("\t<overallStats>" + overall + "</overallStats>" + sep);
                fw.write("\t<outputType>" + this.controller.outputTypeAction.getOutputType() + "</outputType>" + sep);
                int i = 0;
                while (i < this.fstm_.getRowCount()) {
                    Boolean active = (Boolean)this.fstm_.getValueAt(i, 0);
                    String name = (String)this.fstm_.getValueAt(i, 1);
                    String[] attributes = new String[this.controller.dm_.features[i].getFeatureDefinition().attributes.length];
                    j = 0;
                    while (j < attributes.length) {
                        try {
                            attributes[j] = this.controller.dm_.features[i].getElement(j);
                        }
                        catch (Exception e1) {
                            attributes[i] = "";
                            e1.printStackTrace();
                        }
                        ++j;
                    }
                    fw.write("\t<feature>" + sep);
                    fw.write("\t\t<name>" + name + "</name>" + sep);
                    fw.write("\t\t<active>" + active.toString() + "</active>" + sep);
                    j = 0;
                    while (j < attributes.length) {
                        fw.write("\t\t<attribute>" + attributes[j] + "</attribute>" + sep);
                        ++j;
                    }
                    fw.write("\t</feature>" + sep);
                    ++i;
                }
                Aggregator[] aggregatorArray = this.controller.dm_.aggregators;
                int i2 = 0;
                while (i2 < aggregatorArray.length) {
                    String[] aggregatorParameters;
                    fw.write("\t\t\t<aggregator>" + sep);
                    fw.write("\t\t\t\t<aggregatorName>" + aggregatorArray[i2].getAggregatorDefinition().name + "</aggregatorName>" + sep);
                    String[] aggregatorFeatures = aggregatorArray[i2].getFeaturesToApply();
                    if (aggregatorFeatures != null) {
                        int j2 = 0;
                        while (j2 < aggregatorFeatures.length) {
                            fw.write("\t\t\t\t<aggregatorFeature>" + aggregatorFeatures[j2] + "</aggregatorFeature>" + sep);
                            ++j2;
                        }
                    }
                    if ((aggregatorParameters = aggregatorArray[i2].getParamaters()) != null) {
                        j = 0;
                        while (j < aggregatorParameters.length) {
                            fw.write("\t\t\t\t<aggregatorAttribute>" + aggregatorParameters[j] + "</aggregatorAttribute>" + sep);
                            ++j;
                        }
                    }
                    fw.write("\t\t\t</aggregator>" + sep);
                    ++i2;
                }
                fw.write("</save_settings>" + sep);
                fw.close();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
                e1.printStackTrace();
            }
        }
    }

    public void setObjectReferences(JTextArea win_length, JTextArea win_overlap, JCheckBox save_window, JCheckBox save_overall) {
        this.window_length_text_field = win_length;
        this.window_overlap_fraction_text_field = win_overlap;
        this.save_window_features_check_box = save_window;
        this.save_overall_file_featurese_check_box = save_overall;
    }
}

