/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.GeneralTools.PlotDisplay;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.SampleTextDialog;
import jAudioFeatureExtractor.jAudioTools.AudioFormatJFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;
import jAudioFeatureExtractor.jAudioTools.FFT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ProcessSamplesFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private RecordingInfo recording_info;
    private AudioSamples processed_audio_samples;
    private AudioMethodsPlayback.PlayThread playback_thread;
    private OuterFrame outer_frame;
    private Controller controller;
    private AudioFormatJFrame audio_format_selector;
    private JButton choose_possible_format_button;
    private JButton change_encoding_format_button;
    private JButton apply_gain_button;
    private JButton normalize_button;
    private JButton mix_down_button;
    private JButton play_samples_button;
    private JButton stop_playback_button;
    private JButton restore_button;
    private JButton view_samples_button;
    private JButton plot_samples_button;
    private JButton plot_FFT_button;
    private JButton cancel_button;
    private JButton save_button;
    private JTextArea audio_info_text_field;
    private JTextArea choose_gain_text_field;
    private JTextArea start_text_field;
    private JTextArea end_text_field;
    private ButtonGroup start_end_type_radio_button_group;
    private JRadioButton time_start_end_type_radio_button;
    private JRadioButton samples_start_end_type_radio_button;

    public ProcessSamplesFrame(Controller c, OuterFrame of, RecordingInfo recording_info) throws Exception {
        try {
            this.outer_frame = of;
            this.controller = c;
            this.setTitle("Process Audio Samples");
            Color blue = new Color(0.75f, 0.85f, 1.0f);
            this.getContentPane().setBackground(blue);
            of.setEnabled(false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ProcessSamplesFrame.this.cancel();
                }
            });
            this.recording_info = recording_info;
            if (recording_info == null) {
                throw new Exception("Reference to recording to process is empty");
            }
            this.processed_audio_samples = null;
            if (recording_info.samples != null) {
                this.processed_audio_samples = recording_info.samples.getCopyOfAudioSamples();
            } else {
                File load_file = new File(recording_info.file_path);
                this.processed_audio_samples = new AudioSamples(load_file, load_file.getPath(), false);
            }
            this.playback_thread = null;
            this.audio_format_selector = new AudioFormatJFrame();
            AudioFormat default_format = AudioFormatJFrame.getStandardMidQualityRecordAudioFormat();
            this.audio_format_selector.setAudioFormat(default_format);
            int horizontal_gap = 6;
            int vertical_gap = 11;
            this.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
            JPanel top_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
            top_panel.setBackground(this.getContentPane().getBackground());
            JPanel bottom_panel = new JPanel(new GridLayout(13, 3, horizontal_gap, vertical_gap));
            bottom_panel.setBackground(this.getContentPane().getBackground());
            JPanel top_left_panel = new JPanel();
            top_left_panel.setBackground(this.getContentPane().getBackground());
            JPanel top_right_panel = new JPanel();
            top_right_panel.setBackground(this.getContentPane().getBackground());
            top_left_panel.add(new JLabel("Recording Info:"));
            this.audio_info_text_field = new JTextArea(12, 25);
            this.audio_info_text_field.setEditable(false);
            this.updateRecordingInformation();
            top_right_panel.add(this.audio_info_text_field);
            top_panel.add((Component)top_left_panel, "West");
            top_panel.add((Component)top_right_panel, "Center");
            this.add((Component)top_panel, "North");
            this.choose_possible_format_button = new JButton("Choose Possible Format");
            this.choose_possible_format_button.addActionListener(this);
            bottom_panel.add(this.choose_possible_format_button);
            this.change_encoding_format_button = new JButton("Change to Possible Format");
            this.change_encoding_format_button.addActionListener(this);
            bottom_panel.add(this.change_encoding_format_button);
            this.apply_gain_button = new JButton("Apply Gain:");
            this.apply_gain_button.addActionListener(this);
            bottom_panel.add(this.apply_gain_button);
            this.choose_gain_text_field = new JTextArea();
            bottom_panel.add(this.choose_gain_text_field);
            this.normalize_button = new JButton("Normalize");
            this.normalize_button.addActionListener(this);
            bottom_panel.add(this.normalize_button);
            this.mix_down_button = new JButton("Mix Down To One Channel");
            this.mix_down_button.addActionListener(this);
            bottom_panel.add(this.mix_down_button);
            bottom_panel.add(new JLabel(""));
            bottom_panel.add(new JLabel(""));
            bottom_panel.add(new JLabel("Limits Based On:"));
            bottom_panel.add(new JLabel(""));
            this.start_end_type_radio_button_group = new ButtonGroup();
            this.time_start_end_type_radio_button = new JRadioButton("Time");
            this.time_start_end_type_radio_button.setBackground(this.getContentPane().getBackground());
            this.time_start_end_type_radio_button.addActionListener(this);
            this.start_end_type_radio_button_group.add(this.time_start_end_type_radio_button);
            this.samples_start_end_type_radio_button = new JRadioButton("Sample Indices");
            this.samples_start_end_type_radio_button.setBackground(this.getContentPane().getBackground());
            this.samples_start_end_type_radio_button.addActionListener(this);
            this.samples_start_end_type_radio_button.setSelected(true);
            this.start_end_type_radio_button_group.add(this.samples_start_end_type_radio_button);
            bottom_panel.add(this.time_start_end_type_radio_button);
            bottom_panel.add(this.samples_start_end_type_radio_button);
            bottom_panel.add(new JLabel("Start"));
            this.start_text_field = new JTextArea();
            bottom_panel.add(this.start_text_field);
            bottom_panel.add(new JLabel("End"));
            this.end_text_field = new JTextArea();
            bottom_panel.add(this.end_text_field);
            this.convertStartEndFields(true);
            this.play_samples_button = new JButton("Play");
            this.play_samples_button.addActionListener(this);
            bottom_panel.add(this.play_samples_button);
            this.stop_playback_button = new JButton("Stop");
            this.stop_playback_button.addActionListener(this);
            bottom_panel.add(this.stop_playback_button);
            this.restore_button = new JButton("Restore");
            this.restore_button.addActionListener(this);
            bottom_panel.add(this.restore_button);
            this.view_samples_button = new JButton("View Samples");
            this.view_samples_button.addActionListener(this);
            bottom_panel.add(this.view_samples_button);
            this.plot_samples_button = new JButton("Plot Samples");
            this.plot_samples_button.addActionListener(this);
            bottom_panel.add(this.plot_samples_button);
            this.plot_FFT_button = new JButton("Plot Spectrum");
            this.plot_FFT_button.addActionListener(this);
            bottom_panel.add(this.plot_FFT_button);
            bottom_panel.add(new JLabel(""));
            bottom_panel.add(new JLabel(""));
            this.cancel_button = new JButton("Canel");
            this.cancel_button.addActionListener(this);
            bottom_panel.add(this.cancel_button);
            this.save_button = new JButton("Save");
            this.save_button.addActionListener(this);
            bottom_panel.add(this.save_button);
            this.add((Component)bottom_panel, "Center");
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            this.outer_frame.setEnabled(true);
            throw e;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.choose_possible_format_button)) {
            this.chooseEncodingFormt();
        } else if (event.getSource().equals(this.change_encoding_format_button)) {
            this.changeEncodingFormat();
        } else if (event.getSource().equals(this.apply_gain_button)) {
            this.applyGain();
        } else if (event.getSource().equals(this.normalize_button)) {
            this.normalize();
        } else if (event.getSource().equals(this.mix_down_button)) {
            this.mixDownToOneChannel();
        } else if (event.getSource().equals(this.play_samples_button)) {
            this.play();
        } else if (event.getSource().equals(this.stop_playback_button)) {
            this.stopPlayback();
        } else if (event.getSource().equals(this.restore_button)) {
            this.restore();
        } else if (event.getSource().equals(this.view_samples_button)) {
            this.viewSamples();
        } else if (event.getSource().equals(this.plot_samples_button)) {
            this.viewSignalPlot();
        } else if (event.getSource().equals(this.plot_FFT_button)) {
            this.viewSpectrum();
        } else if (event.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (event.getSource().equals(this.save_button)) {
            this.save();
        } else if (event.getSource().equals(this.time_start_end_type_radio_button)) {
            this.convertStartEndFields(false);
        } else if (event.getSource().equals(this.samples_start_end_type_radio_button)) {
            this.convertStartEndFields(false);
        }
    }

    private void chooseEncodingFormt() {
        this.audio_format_selector.setVisible(true);
    }

    private void changeEncodingFormat() {
        try {
            AudioFormat new_audio_format = this.audio_format_selector.getAudioFormat(false);
            if (new_audio_format.getSampleSizeInBits() != 16 && new_audio_format.getSampleSizeInBits() != 8 || !new_audio_format.isBigEndian() || new_audio_format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                throw new Exception("Only 8 or 16 bit signed PCM samples with a big-endian\nbyte order can be used currently.");
            }
            AudioInputStream original_audio_input_stream = this.processed_audio_samples.getAudioInputStreamChannelSegregated();
            int original_number_channels = original_audio_input_stream.getFormat().getChannels();
            if (original_number_channels != new_audio_format.getChannels()) {
                throw new Exception("Original audio has " + original_number_channels + " channels but the\n" + "new format has " + new_audio_format.getChannels() + "channels.\n" + "These must match.");
            }
            AudioInputStream new_audio_input_stream = AudioSystem.getAudioInputStream(new_audio_format, original_audio_input_stream);
            this.processed_audio_samples = new AudioSamples(new_audio_input_stream, this.processed_audio_samples.getUniqueIdentifier(), false);
            this.updateRecordingInformation();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void applyGain() {
        try {
            double[][] samples = this.processed_audio_samples.getSamplesChannelSegregated();
            double gain = new Double(this.choose_gain_text_field.getText());
            samples = DSPMethods.applyGain(samples, gain);
            this.processed_audio_samples.setSamples(samples);
            this.updateRecordingInformation();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void normalize() {
        this.processed_audio_samples.normalize();
        this.updateRecordingInformation();
    }

    private void mixDownToOneChannel() {
        Object new_samples = new double[][]{this.processed_audio_samples.getSamplesMixedDown()};
        new_samples = DSPMethods.getCopyOfSamples(new_samples);
        AudioFormat old_audio_format = this.processed_audio_samples.getAudioFormat();
        AudioFormat new_audio_format = new AudioFormat(old_audio_format.getSampleRate(), old_audio_format.getSampleSizeInBits(), 1, true, old_audio_format.isBigEndian());
        try {
            this.processed_audio_samples = new AudioSamples((double[][])new_samples, new_audio_format, this.processed_audio_samples.getUniqueIdentifier(), false);
            this.updateRecordingInformation();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void play() {
        try {
            this.verifyStartAndEndFields();
            AudioInputStream audio_input_stream = null;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double start_time = new Double(this.start_text_field.getText());
                double end_time = new Double(this.end_text_field.getText());
                audio_input_stream = this.processed_audio_samples.getAudioInputStreamChannelSegregated(start_time, end_time);
            } else {
                int start_sample = new Integer(this.start_text_field.getText());
                int end_sample = new Integer(this.end_text_field.getText());
                audio_input_stream = this.processed_audio_samples.getAudioInputStreamChannelSegregated(start_sample, end_sample);
            }
            SourceDataLine source_data_line = AudioMethods.getSourceDataLine(audio_input_stream.getFormat(), null);
            this.stopPlayback();
            this.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audio_input_stream, source_data_line);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void stopPlayback() {
        if (this.playback_thread != null) {
            this.playback_thread.stopPlaying();
        }
        this.playback_thread = null;
    }

    private void viewSamples() {
        try {
            this.verifyStartAndEndFields();
            int start_sample = 0;
            int end_sample = 0;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double start_time = new Double(this.start_text_field.getText());
                double end_time = new Double(this.end_text_field.getText());
                float sampling_rate = this.processed_audio_samples.getAudioFormat().getSampleRate();
                start_sample = DSPMethods.convertTimeToSample(start_time, sampling_rate);
                end_sample = DSPMethods.convertTimeToSample(end_time, sampling_rate);
            } else {
                start_sample = new Integer(this.start_text_field.getText());
                end_sample = new Integer(this.end_text_field.getText());
            }
            SampleTextDialog displayer = new SampleTextDialog();
            JTextArea text_area = displayer.getTextArea();
            double[][] samples = this.processed_audio_samples.getSamplesChannelSegregated(start_sample, end_sample);
            text_area.append("SAMPLE\t");
            int chan = 0;
            while (chan < samples.length) {
                text_area.append("CHANNEL " + chan + "\t\t");
                ++chan;
            }
            int samp = start_sample;
            while (samp <= end_sample) {
                text_area.append("\n" + samp + "\t");
                int chan2 = 0;
                while (chan2 < samples.length) {
                    text_area.append(String.valueOf(samples[chan2][samp]) + "\t\t");
                    ++chan2;
                }
                ++samp;
            }
            displayer.display();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void viewSignalPlot() {
        try {
            this.verifyStartAndEndFields();
            int start_sample = 0;
            int end_sample = 0;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double start_time = new Double(this.start_text_field.getText());
                double end_time = new Double(this.end_text_field.getText());
                float sampling_rate = this.processed_audio_samples.getAudioFormat().getSampleRate();
                start_sample = DSPMethods.convertTimeToSample(start_time, sampling_rate);
                end_sample = DSPMethods.convertTimeToSample(end_time, sampling_rate);
            } else {
                start_sample = new Integer(this.start_text_field.getText());
                end_sample = new Integer(this.end_text_field.getText());
            }
            double[][] samples = this.processed_audio_samples.getSamplesChannelSegregated(start_sample, end_sample);
            double[][] x_labels = new double[samples.length][samples[0].length];
            int chan = 0;
            while (chan < x_labels.length) {
                int samp = 0;
                while (samp < x_labels[chan].length) {
                    int ef_sample = samp + start_sample;
                    x_labels[chan][samp] = this.time_start_end_type_radio_button.isSelected() ? (double)ef_sample / this.processed_audio_samples.getSamplingRateAsDouble() : (double)ef_sample;
                    ++samp;
                }
                ++chan;
            }
            PlotDisplay plotter = new PlotDisplay(samples, x_labels, false, this.processed_audio_samples.getUniqueIdentifier(), false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void viewSpectrum() {
        try {
            this.verifyStartAndEndFields();
            int start_sample = 0;
            int end_sample = 0;
            if (this.time_start_end_type_radio_button.isSelected()) {
                double start_time = new Double(this.start_text_field.getText());
                double end_time = new Double(this.end_text_field.getText());
                float sampling_rate = this.processed_audio_samples.getAudioFormat().getSampleRate();
                start_sample = DSPMethods.convertTimeToSample(start_time, sampling_rate);
                end_sample = DSPMethods.convertTimeToSample(end_time, sampling_rate);
            } else {
                start_sample = new Integer(this.start_text_field.getText());
                end_sample = new Integer(this.end_text_field.getText());
            }
            double[][] samples = this.processed_audio_samples.getSamplesChannelSegregated(start_sample, end_sample);
            double[][] powers = new double[samples.length][];
            double[] labels = null;
            int chan = 0;
            while (chan < powers.length) {
                FFT fft2 = new FFT(samples[chan], null, false, true);
                powers[chan] = fft2.getPowerSpectrum();
                if (labels == null) {
                    labels = fft2.getBinLabels(this.processed_audio_samples.getSamplingRateAsDouble());
                }
                ++chan;
            }
            double[][] x_labels = new double[samples.length][];
            int chan2 = 0;
            while (chan2 < x_labels.length) {
                x_labels[chan2] = labels;
                ++chan2;
            }
            PlotDisplay plotter = new PlotDisplay(powers, x_labels, false, this.processed_audio_samples.getUniqueIdentifier(), false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void restore() {
        try {
            this.processed_audio_samples = null;
            if (this.recording_info.samples != null) {
                this.processed_audio_samples = this.recording_info.samples.getCopyOfAudioSamples();
            } else {
                File load_file = new File(this.recording_info.file_path);
                this.processed_audio_samples = new AudioSamples(load_file, load_file.getPath(), false);
            }
            this.convertStartEndFields(true);
            this.updateRecordingInformation();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void cancel() {
        this.stopPlayback();
        this.recording_info = null;
        this.processed_audio_samples = null;
        this.audio_format_selector = null;
        System.gc();
        this.outer_frame.setEnabled(true);
        this.setVisible(false);
    }

    private void save() {
        try {
            File save_file = new File(this.recording_info.file_path);
            AudioFileFormat.Type file_format = AudioFileFormat.Type.WAVE;
            if (save_file.exists()) {
                file_format = AudioSystem.getAudioFileFormat(save_file).getType();
            }
            this.processed_audio_samples.saveAudio(save_file, true, file_format, false);
            if (this.recording_info.samples != null) {
                this.recording_info.samples = this.processed_audio_samples;
            }
            this.cancel();
        }
        catch (Exception e) {
            String message = "Unable to save changes:\n";
            JOptionPane.showMessageDialog(null, String.valueOf(message) + e.getMessage(), "ERROR", 0);
        }
    }

    private void updateRecordingInformation() {
        String header = "FILE: " + this.recording_info.file_path + "\n";
        this.audio_info_text_field.setText(String.valueOf(header) + this.processed_audio_samples.getRecordingInfo());
    }

    private void convertStartEndFields(boolean reset) {
        if (reset) {
            if (this.time_start_end_type_radio_button.isSelected()) {
                this.start_text_field.setText("0");
                String end_time = String.valueOf(this.processed_audio_samples.getDuration());
                this.end_text_field.setText(end_time);
            } else {
                this.start_text_field.setText("0");
                String end_sample = String.valueOf(this.processed_audio_samples.getNumberSamplesPerChannel() - 1);
                this.end_text_field.setText(end_sample);
            }
        } else {
            float sampling_rate = this.processed_audio_samples.getSamplingRate();
            if (this.time_start_end_type_radio_button.isSelected()) {
                int start_sample = (int)new Double(this.start_text_field.getText()).doubleValue();
                double start_time = DSPMethods.convertSampleToTime(start_sample, sampling_rate);
                this.start_text_field.setText(String.valueOf(start_time));
                int end_sample = (int)new Double(this.end_text_field.getText()).doubleValue();
                double end_time = DSPMethods.convertSampleToTime(end_sample, sampling_rate);
                this.end_text_field.setText(String.valueOf(end_time));
            } else {
                double start_time = new Double(this.start_text_field.getText());
                int start_sample = DSPMethods.convertTimeToSample(start_time, sampling_rate);
                this.start_text_field.setText(String.valueOf(start_sample));
                double end_time = new Double(this.end_text_field.getText());
                int end_sample = DSPMethods.convertTimeToSample(end_time, sampling_rate);
                this.end_text_field.setText(String.valueOf(end_sample));
            }
        }
    }

    private void verifyStartAndEndFields() throws Exception {
        if (this.time_start_end_type_radio_button.isSelected()) {
            double start_time = new Double(this.start_text_field.getText());
            double end_time = new Double(this.end_text_field.getText());
            double maximum_duration = this.processed_audio_samples.getDuration();
            if (start_time < 0.0 || start_time > maximum_duration) {
                throw new Exception("Start time is specified to be " + start_time + ".\n" + "This value must be between 0 and " + maximum_duration + ".");
            }
            if (end_time <= start_time) {
                throw new Exception("End time is " + end_time + " and start time is " + start_time + ".\n" + "Start time must be after end time.");
            }
            if (end_time > maximum_duration) {
                throw new Exception("End time of " + end_time + " is greater than the total duration of " + maximum_duration + ".\n" + "Start time must be after end time.");
            }
            float sampling_rate = this.processed_audio_samples.getAudioFormat().getSampleRate();
        } else {
            int start_sample = new Integer(this.start_text_field.getText());
            int end_sample = new Integer(this.end_text_field.getText());
            int maximum_sample = this.processed_audio_samples.getNumberSamplesPerChannel();
            if (start_sample < 0 || start_sample > maximum_sample) {
                throw new Exception("Start sample is specified to be " + start_sample + ".\n" + "This value must be between 0 and " + maximum_sample + ".");
            }
            if (end_sample <= start_sample) {
                throw new Exception("End sample is " + end_sample + " and start sample is " + start_sample + ".\n" + "Start sample must be after end sample.");
            }
            if (end_sample > maximum_sample) {
                throw new Exception("End sample of " + end_sample + " is greater than the total samples of " + maximum_sample + ".\n" + "Start sample must be after end sample.");
            }
        }
    }
}

