/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.ExtractionThread;
import jAudioFeatureExtractor.FeatureSelectorPanel;
import jAudioFeatureExtractor.RecordingSelectorPanel;
import jAudioFeatureExtractor.actions.ExecuteBatchAction;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.multihelp.HelpWindow;

public class OuterFrame
extends JFrame {
    static final long serialVersionUID = 1L;
    public RecordingSelectorPanel recording_selector_panel;
    public FeatureSelectorPanel feature_selector_panel;
    public Controller controller;
    public JMenuBar menu;
    public JRadioButtonMenuItem ace;
    public JRadioButtonMenuItem arff;
    public HelpWindow helpWindow = null;

    public OuterFrame(Controller c) {
        SplashFrame splash = new SplashFrame();
        splash.loadSplash();
        this.setTitle("jAudio Feature Extractor");
        this.setDefaultCloseOperation(3);
        this.controller = c;
        this.ace = new JRadioButtonMenuItem("ACE");
        this.arff = new JRadioButtonMenuItem("ARFF");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.ace);
        bg.add(this.arff);
        this.recording_selector_panel = new RecordingSelectorPanel(this, c);
        this.feature_selector_panel = new FeatureSelectorPanel(this, c);
        this.controller.normalise = new JCheckBoxMenuItem("Normalise Recordings", false);
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        this.feature_selector_panel.setBackground(blue);
        this.recording_selector_panel.setBackground(blue);
        this.ace.setSelected(true);
        this.ace.addActionListener(this.controller.outputTypeAction);
        this.arff.addActionListener(this.controller.outputTypeAction);
        this.controller.extractionThread = new ExtractionThread(this.controller, this);
        this.controller.executeBatchAction = new ExecuteBatchAction(this.controller, this);
        JRadioButtonMenuItem sample8 = new JRadioButtonMenuItem("8");
        JRadioButtonMenuItem sample11 = new JRadioButtonMenuItem("11.025");
        JRadioButtonMenuItem sample16 = new JRadioButtonMenuItem("16");
        JRadioButtonMenuItem sample22 = new JRadioButtonMenuItem("22.05");
        JRadioButtonMenuItem sample44 = new JRadioButtonMenuItem("44.1");
        ButtonGroup sr = new ButtonGroup();
        sr.add(sample8);
        sr.add(sample11);
        sr.add(sample16);
        sr.add(sample22);
        sr.add(sample44);
        sample16.setSelected(true);
        sample8.addActionListener(this.controller.samplingRateAction);
        sample11.addActionListener(this.controller.samplingRateAction);
        sample16.addActionListener(this.controller.samplingRateAction);
        sample22.addActionListener(this.controller.samplingRateAction);
        sample44.addActionListener(this.controller.samplingRateAction);
        this.controller.samplingRateAction.setTarget(new JRadioButtonMenuItem[]{sample8, sample11, sample16, sample22, sample44});
        this.controller.removeBatch = new JMenu();
        this.controller.viewBatch = new JMenu();
        JMenuItem helpTopics = new JMenuItem("Help Topics");
        this.menu = new JMenuBar();
        this.menu.setBackground(blue);
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(c.saveAction);
        fileMenu.add(c.saveBatchAction);
        fileMenu.add(c.loadAction);
        fileMenu.add(c.loadBatchAction);
        fileMenu.addSeparator();
        fileMenu.add(c.addBatchAction);
        fileMenu.add(c.executeBatchAction);
        this.controller.removeBatch = new JMenu("Remove Batch");
        this.controller.removeBatch.setEnabled(false);
        fileMenu.add(c.removeBatch);
        this.controller.viewBatch = new JMenu("View Batch");
        this.controller.viewBatch.setEnabled(false);
        fileMenu.add(c.viewBatch);
        fileMenu.addSeparator();
        fileMenu.add(c.exitAction);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(c.cutAction);
        editMenu.add(c.copyAction);
        editMenu.add(c.pasteAction);
        JMenu recordingMenu = new JMenu("Recording");
        recordingMenu.add(c.addRecordingsAction);
        recordingMenu.add(c.editRecordingsAction);
        recordingMenu.add(c.removeRecordingsAction);
        recordingMenu.add(c.recordFromMicAction);
        recordingMenu.add(c.synthesizeAction);
        recordingMenu.add(c.viewFileInfoAction);
        recordingMenu.add(c.storeSamples);
        recordingMenu.add(c.validate);
        JMenu analysisMenu = new JMenu("Analysis");
        analysisMenu.add(c.globalWindowChangeAction);
        c.outputType = new JMenu("Output Format");
        c.outputType.add(this.ace);
        c.outputType.add(this.arff);
        analysisMenu.add(c.outputType);
        c.sampleRate = new JMenu("Sample Rate (kHz)");
        c.sampleRate.add(sample8);
        c.sampleRate.add(sample11);
        c.sampleRate.add(sample16);
        c.sampleRate.add(sample22);
        c.sampleRate.add(sample44);
        analysisMenu.add(c.sampleRate);
        analysisMenu.add(this.controller.normalise);
        JMenu playbackMenu = new JMenu("Playback");
        playbackMenu.add(c.playNowAction);
        playbackMenu.add(c.playSamplesAction);
        playbackMenu.add(c.stopPlayBackAction);
        playbackMenu.add(c.playMIDIAction);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(helpTopics);
        helpMenu.add(c.aboutAction);
        helpTopics.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Help Window Started");
                if (OuterFrame.this.helpWindow == null) {
                    OuterFrame.this.helpWindow = new HelpWindow();
                }
            }
        });
        this.menu.add(fileMenu);
        this.menu.add(editMenu);
        this.menu.add(recordingMenu);
        this.menu.add(analysisMenu);
        this.menu.add(playbackMenu);
        this.menu.add(helpMenu);
        this.setLayout(new BorderLayout(8, 8));
        this.add((Component)this.recording_selector_panel, "West");
        this.add((Component)this.feature_selector_panel, "East");
        this.add((Component)this.menu, "North");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("jAudioLogo3-16.bmp"));
        this.pack();
        splash.endSplash();
        splash = null;
        this.setVisible(true);
    }

    public HelpWindow getHelpSet(String helpsetfile) {
        HelpWindow hs = new HelpWindow();
        return hs;
    }

    protected class ImageCanvas
    extends Canvas {
        private Image image;

        public ImageCanvas(Image image) {
            this.image = image;
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(image, 0);
            try {
                mt.waitForID(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, this);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 400);
        }
    }

    protected class SplashFrame
    extends Frame {
        private Window window = new Window(this);
        private Image image = Toolkit.getDefaultToolkit().getImage("jAudioLogo3-400.jpg");
        private ImageCanvas canvas;

        protected SplashFrame() {
        }

        public void loadSplash() {
            this.canvas = new ImageCanvas(this.image);
            this.window.add((Component)this.canvas, "Center");
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.window.setLocation(screenSize.width / 2 - 200, screenSize.height / 2 - 200);
            this.window.setSize(400, 400);
            this.window.pack();
            this.window.show();
            this.window.toFront();
        }

        public void endSplash() {
            this.window.dispose();
        }
    }
}

