/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class StrongestFrequencyViaZeroCrossings
extends FeatureExtractor {
    public StrongestFrequencyViaZeroCrossings() {
        String name = "Strongest Frequency Via Zero Crossings";
        String description = "The strongest frequency component of a signal, in Hz, found via the number of zero-crossings.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[1];
        this.dependencies[0] = "Zero Crossings";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double zero_crossings = other_feature_values[0][0];
        double[] result = new double[]{zero_crossings / 2.0 * (sampling_rate / (double)samples.length)};
        return result;
    }

    @Override
    public Object clone() {
        return new StrongestFrequencyViaZeroCrossings();
    }
}

