/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;

public class StrongestFrequencyViaFFTMax
extends FeatureExtractor {
    public StrongestFrequencyViaFFTMax() {
        String name = "Strongest Frequency Via FFT Maximum";
        String description = "The strongest frequency component of a signal, in Hz, found via finding the FFT bin with the highest power.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[2];
        this.dependencies[0] = "Power Spectrum";
        this.dependencies[1] = "FFT Bin Frequency Labels";
        this.offsets = new int[2];
        this.offsets[0] = 0;
        this.offsets[1] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] power_spectrum = other_feature_values[0];
        double[] labels = other_feature_values[1];
        int highest_bin = Statistics.getIndexOfLargest(power_spectrum);
        double[] result = new double[]{labels[highest_bin]};
        return result;
    }

    @Override
    public Object clone() {
        return new StrongestFrequencyViaFFTMax();
    }
}

