/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;

public class StrongestFrequencyVariability
extends FeatureExtractor {
    public StrongestFrequencyVariability() {
        String name = "Strongest Frequency Variability";
        String description = "The standard deviation of the frequency of thepower spectrum bin with the highest power overthe last 100 windows.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        int number_windows = 100;
        this.dependencies = new String[number_windows];
        int i = 0;
        while (i < this.dependencies.length) {
            this.dependencies[i] = "Strongest Frequency Via FFT Maximum";
            ++i;
        }
        this.offsets = new int[number_windows];
        i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] freq = other_feature_values[0];
        double std_dev = Statistics.getStandardDeviation(freq);
        double[] result = new double[]{std_dev};
        return result;
    }

    @Override
    public Object clone() {
        return new StrongestFrequencyVariability();
    }
}

