/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.AudioFeatures.MetaFeatureFactory;

public class StandardDeviation
extends MetaFeatureFactory {
    int sampleWidth = 100;

    public StandardDeviation() {
    }

    public StandardDeviation(MetaFeatureFactory mff) {
        this.chainMetaFeatureFactory(mff);
    }

    @Override
    public MetaFeatureFactory defineFeature(FeatureExtractor fe) {
        StandardDeviation ret = new StandardDeviation();
        ret.fe_ = this.fe_ != null & this.fe_ instanceof MetaFeatureFactory ? ((MetaFeatureFactory)this.fe_).defineFeature(fe) : fe;
        String name = "Standard Deviation of " + ret.fe_.getFeatureDefinition().name;
        String description = "Standard Deviation of " + ret.fe_.getFeatureDefinition().name + "." + ret.fe_.getFeatureDefinition().description;
        String[] oldAttributes = fe.getFeatureDefinition().attributes;
        String[] myAttributes = new String[oldAttributes.length + 1];
        int i = 0;
        while (i < oldAttributes.length) {
            myAttributes[i] = oldAttributes[i];
            ++i;
        }
        myAttributes[myAttributes.length - 1] = "Size of Window to calculate accross";
        ret.definition = new FeatureDefinition(name, description, true, ret.fe_.getFeatureDefinition().dimensions, myAttributes);
        ret.dependencies = new String[this.sampleWidth];
        ret.offsets = new int[this.sampleWidth];
        i = 0;
        while (i < this.sampleWidth) {
            ret.dependencies[i] = ret.fe_.getFeatureDefinition().name;
            ret.offsets[i] = 0 - i;
            ++i;
        }
        return ret;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] ret = new double[other_feature_values[0].length];
        double[] x2 = new double[other_feature_values[0].length];
        double[] x = new double[other_feature_values[0].length];
        int i = 0;
        while (i < other_feature_values[0].length) {
            x2[i] = 0.0;
            x[i] = 0.0;
            int j = 0;
            while (j < other_feature_values.length) {
                int n = i;
                x2[n] = x2[n] + other_feature_values[j][i] * other_feature_values[j][i];
                int n2 = i;
                x[n2] = x[n2] + other_feature_values[j][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < other_feature_values[0].length) {
            ret[i] = x[i] * x[i] - x2[i];
            int n = i;
            ret[n] = ret[n] / (double)(other_feature_values.length - 1);
            ret[i] = Math.sqrt(ret[i]);
            ++i;
        }
        return ret;
    }

    @Override
    public void setWindow(int n) throws Exception {
        if (n <= 1) {
            throw new Exception("Width must be 2 or greater");
        }
        this.sampleWidth = n;
        if (this.fe_ != null) {
            String tmp = this.fe_.getFeatureDefinition().name;
            this.dependencies = new String[this.sampleWidth];
            this.offsets = new int[this.sampleWidth];
            int i = 0;
            while (i < this.sampleWidth) {
                this.dependencies[i] = tmp;
                this.offsets[i] = 0 - i;
                ++i;
            }
        } else {
            this.dependencies = null;
            this.offsets = null;
        }
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index >= this.definition.attributes.length || index < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + index);
        }
        if (index == this.definition.attributes.length - 1) {
            return Integer.toString(this.sampleWidth);
        }
        if (this.fe_ != null) {
            return this.fe_.getElement(index);
        }
        throw new Exception("INTERNAL ERROR: Request for child attribute in Standrad Deviation when the child is null");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index >= this.definition.attributes.length || index < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + index);
        }
        if (index == this.definition.attributes.length - 1) {
            try {
                int type = Integer.parseInt(value);
                if (type <= 1) {
                    throw new Exception("width of the window must be greater than 1");
                }
                this.setWindow(type);
            }
            catch (NumberFormatException e) {
                throw new Exception("Width of window must be an integer");
            }
        } else if (this.fe_ != null) {
            this.fe_.setElement(index, value);
        } else {
            throw new Exception("Request to set a child in StandardDeviation attrbiute when the child is null");
        }
    }

    @Override
    public Object clone() {
        if (this.fe_ == null) {
            return new StandardDeviation();
        }
        if (this.fe_ instanceof MetaFeatureFactory) {
            StandardDeviation ret = new StandardDeviation();
            ret.fe_ = (FeatureExtractor)this.fe_.clone();
            ret.definition = new FeatureDefinition(this.definition.name, this.definition.description, true, this.definition.dimensions, (String[])this.definition.attributes.clone());
            try {
                ret.setWindow(this.sampleWidth);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }
        StandardDeviation ret = (StandardDeviation)this.defineFeature((FeatureExtractor)this.fe_.clone());
        try {
            ret.setWindow(this.sampleWidth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        String name = this.definition.name;
        String description = this.definition.description;
        FeatureDefinition childFD = null;
        if (this.fe_ == null) {
            return this.definition;
        }
        childFD = this.fe_.getFeatureDefinition();
        String[] attributes = new String[childFD.attributes.length + 1];
        int i = 0;
        while (i < childFD.attributes.length) {
            attributes[i] = childFD.attributes[i];
            ++i;
        }
        attributes[attributes.length - 1] = "Size of Window for Standard Deviation";
        int dimensions = childFD.dimensions;
        this.definition = new FeatureDefinition(name, description, true, dimensions, attributes);
        return this.definition;
    }
}

