/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;

public class SpectralVariability
extends FeatureExtractor {
    public SpectralVariability() {
        String name = "Spectral Variability";
        String description = "The standard deviation of the magnitude spectrum. This is a measure of the variance of a signal's magnitude spectrum.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[1];
        this.dependencies[0] = "Magnitude Spectrum";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] mag_spec = other_feature_values[0];
        double variance = Statistics.getStandardDeviation(mag_spec);
        double[] result = new double[]{variance};
        return result;
    }

    @Override
    public Object clone() {
        return new SpectralVariability();
    }
}

