/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class SpectralRolloffPoint
extends FeatureExtractor {
    protected double cutoff = 0.85;

    public SpectralRolloffPoint() {
        String name = "Spectral Rolloff Point";
        String description = "The fraction of bins in the power spectrum at which 85% of the power is at lower frequencies. This is a measure of the right-skewedness of the power spectrum.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions, new String[]{"Cutoff point (0-1)"});
        this.dependencies = new String[1];
        this.dependencies[0] = "Power Spectrum";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] pow_spectrum = other_feature_values[0];
        double total = 0.0;
        int bin = 0;
        while (bin < pow_spectrum.length) {
            total += pow_spectrum[bin];
            ++bin;
        }
        double threshold = total * this.cutoff;
        total = 0.0;
        int point = 0;
        int bin2 = 0;
        while (bin2 < pow_spectrum.length) {
            if ((total += pow_spectrum[bin2]) >= threshold) {
                point = bin2;
                bin2 = pow_spectrum.length;
            }
            ++bin2;
        }
        double[] result = new double[]{(double)point / (double)pow_spectrum.length};
        return result;
    }

    @Override
    public Object clone() {
        SpectralRolloffPoint ret = new SpectralRolloffPoint();
        ret.cutoff = this.cutoff;
        return ret;
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:getElement");
        }
        return Double.toString(this.cutoff);
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:setElement");
        }
        try {
            double type = Double.parseDouble(value);
            this.setCutoff(type);
        }
        catch (Exception e) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    public void setCutoff(double c) throws Exception {
        if (Double.isInfinite(c) || Double.isNaN(c)) {
            throw new Exception("SpectralRolloff cutoff must be a real number");
        }
        if (c <= 0.0 || c >= 1.0) {
            throw new Exception("SpectralRolloff cutoff must be gretaer than 0 and less than 1");
        }
        this.cutoff = c;
    }
}

