/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class SpectralCentroid
extends FeatureExtractor {
    public SpectralCentroid() {
        String name = "Spectral Centroid";
        String description = "The centre of mass of the power spectrum.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[1];
        this.dependencies[0] = "Power Spectrum";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] pow_spectrum = other_feature_values[0];
        double total = 0.0;
        double weighted_total = 0.0;
        int bin = 0;
        while (bin < pow_spectrum.length) {
            weighted_total += (double)bin * pow_spectrum[bin];
            total += pow_spectrum[bin];
            ++bin;
        }
        double[] result = new double[]{total != 0.0 ? weighted_total / total : 0.0};
        return result;
    }

    @Override
    public Object clone() {
        return new SpectralCentroid();
    }
}

