/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class Moments
extends FeatureExtractor {
    public Moments() {
        String name = "Method of Moments";
        String description = "Statistical Method of Moments of the Magnitude Spectrum.";
        this.definition = new FeatureDefinition(name, description, true, 5);
        this.dependencies = new String[]{"Magnitude Spectrum"};
        this.offsets = new int[1];
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] ret = new double[5];
        double[] mom = new double[5];
        double scale = 0.0;
        double tmp = 0.0;
        int i = 0;
        while (i < other_feature_values[0].length) {
            scale += other_feature_values[0][i];
            ++i;
        }
        if (scale == 0.0) {
            return new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        }
        i = 0;
        while (i < other_feature_values[0].length) {
            tmp = other_feature_values[0][i] / scale;
            int j = 1;
            while (j < ret.length) {
                int n = j++;
                mom[n] = mom[n] + (tmp *= (double)i);
            }
            ++i;
        }
        ret[0] = scale;
        ret[1] = mom[1];
        ret[2] = mom[2] - mom[1] * mom[1];
        ret[3] = 2.0 * Math.pow(mom[1], 3.0) - 3.0 * mom[1] * mom[2] + mom[3];
        ret[4] = -3.0 * Math.pow(mom[1], 4.0) + 6.0 * mom[1] * mom[1] * mom[2] - 4.0 * mom[1] * mom[3] + mom[4];
        return ret;
    }

    @Override
    public Object clone() {
        return new Moments();
    }
}

