/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.AudioFeatures.MetaFeatureFactory;

public class Mean
extends MetaFeatureFactory {
    protected int runningAverage = 100;

    public Mean() {
    }

    public Mean(MetaFeatureFactory mff) {
        this.chainMetaFeatureFactory(mff);
    }

    @Override
    public MetaFeatureFactory defineFeature(FeatureExtractor fe) {
        Mean tmp = new Mean();
        tmp.fe_ = this.fe_ != null & this.fe_ instanceof MetaFeatureFactory ? ((MetaFeatureFactory)this.fe_).defineFeature(fe) : fe;
        tmp.fe_ = fe;
        String name = "Running Mean of " + fe.getFeatureDefinition().name;
        String description = "Running Mean of " + fe.getFeatureDefinition().name + ". " + fe.getFeatureDefinition().description;
        String[] oldAttributes = fe.getFeatureDefinition().attributes;
        String[] myAttributes = new String[oldAttributes.length + 1];
        int i = 0;
        while (i < oldAttributes.length) {
            myAttributes[i] = oldAttributes[i];
            ++i;
        }
        myAttributes[myAttributes.length - 1] = "Size of Window to Average accross";
        tmp.definition = new FeatureDefinition(name, description, true, fe.getFeatureDefinition().dimensions, myAttributes);
        tmp.dependencies = new String[this.runningAverage];
        tmp.offsets = new int[this.runningAverage];
        i = 0;
        while (i < this.runningAverage) {
            tmp.dependencies[i] = fe.getFeatureDefinition().name;
            tmp.offsets[i] = 0 - i;
            ++i;
        }
        return tmp;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] ret = new double[other_feature_values[0].length];
        int i = 0;
        while (i < ret.length) {
            int j = 0;
            while (j < other_feature_values.length) {
                int n = i;
                ret[n] = ret[n] + other_feature_values[j][i];
                ++j;
            }
            int n = i++;
            ret[n] = ret[n] / (double)other_feature_values.length;
        }
        return ret;
    }

    @Override
    public void setWindow(int n) throws Exception {
        if (n <= 1) {
            throw new Exception("new value for running average must be greater than one");
        }
        this.runningAverage = n;
        if (this.fe_ != null) {
            String tmp = this.fe_.getFeatureDefinition().name;
            this.dependencies = new String[this.runningAverage];
            this.offsets = new int[this.runningAverage];
            int i = 0;
            while (i < this.runningAverage) {
                this.dependencies[i] = tmp;
                this.offsets[i] = 0 - i;
                ++i;
            }
        } else {
            this.dependencies = null;
            this.offsets = null;
        }
        super.setWindow(n);
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index >= this.definition.attributes.length || index < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + index);
        }
        if (index == this.definition.attributes.length - 1) {
            return Integer.toString(this.runningAverage);
        }
        if (this.fe_ != null) {
            return this.fe_.getElement(index);
        }
        throw new Exception("INTERNAL ERROR: non-existant index for Mean:getElement - claims to have children, but child is null");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index >= this.definition.attributes.length || index < 0) {
            throw new Exception("INTERNAL ERROR: Request for an invalid index " + index);
        }
        if (index == this.definition.attributes.length - 1) {
            try {
                int type = Integer.parseInt(value);
                if (type <= 1) {
                    throw new Exception("width of the window must be greater than 1");
                }
                this.setWindow(type);
            }
            catch (NumberFormatException e) {
                throw new Exception("Width of window must be an integer");
            }
        } else if (this.fe_ != null) {
            this.fe_.setElement(index, value);
        } else {
            throw new Exception("INTERNAL ERROR: non-existant index for Mean:getElement - claims to have children, but child is null");
        }
    }

    @Override
    public Object clone() {
        if (this.fe_ == null) {
            return new Mean();
        }
        if (this.fe_ instanceof MetaFeatureFactory) {
            Mean ret = new Mean();
            ret.fe_ = (FeatureExtractor)this.fe_.clone();
            try {
                ret.setWindow(this.runningAverage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String name = this.definition.name;
            String description = this.definition.description;
            String[] attributes = this.definition.attributes;
            int dim = this.definition.dimensions;
            ret.definition = new FeatureDefinition(name, description, true, dim, attributes);
            ret.dependencies = (String[])this.dependencies.clone();
            ret.offsets = (int[])this.offsets.clone();
            try {
                ret.setWindow(this.runningAverage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return ret;
        }
        Mean ret = (Mean)this.defineFeature((FeatureExtractor)this.fe_.clone());
        try {
            ret.setWindow(this.runningAverage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        String name = this.definition.name;
        String description = this.definition.description;
        FeatureDefinition childFD = null;
        if (this.fe_ == null) {
            return this.definition;
        }
        childFD = this.fe_.getFeatureDefinition();
        String[] attributes = new String[childFD.attributes.length + 1];
        int i = 0;
        while (i < childFD.attributes.length) {
            attributes[i] = childFD.attributes[i];
            ++i;
        }
        attributes[attributes.length - 1] = "Size of Window to Average accross";
        int dimensions = childFD.dimensions;
        this.definition = new FeatureDefinition(name, description, true, dimensions, attributes);
        return this.definition;
    }
}

