/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class HarmonicSpectralCentroid
extends FeatureExtractor {
    public HarmonicSpectralCentroid() {
        String name = "Partial Based Spectral Centroid";
        String description = "Spectral Centroid calculated based on the center of mass of partials instead of center of mass of bins.";
        this.definition = new FeatureDefinition(name, description, true, 1);
        this.dependencies = new String[]{"Peak Detection"};
        this.offsets = new int[1];
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) {
        double[] result = new double[1];
        double[] peaks = other_feature_values[0];
        double total = 0.0;
        double weightedTotal = 0.0;
        int i = 0;
        while (i < peaks.length) {
            weightedTotal += (double)(i / 2) * peaks[i];
            total += peaks[i];
            ++i;
        }
        result[0] = weightedTotal / total;
        return result;
    }

    @Override
    public Object clone() {
        return new HarmonicSpectralCentroid();
    }
}

