/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.util.Arrays;

public class ConstantQ
extends FeatureExtractor {
    int n;
    double alpha = 1.0;
    int[] nk;
    double[] freq;
    double[][] kernelReal;
    double[][] kernelImaginary;

    public ConstantQ() {
        String name = "ConstantQ";
        String description = "signal to frequency transform using exponential-spaced frequency bins.";
        boolean is_sequential = true;
        int dimensions = 0;
        String[] attributes = new String[]{"Percent of a semitone per bin"};
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions, attributes);
        this.dependencies = null;
        this.offsets = null;
        this.alpha = 1.0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        this.calcFreq(samples, sampling_rate);
        this.calcNk(samples);
        this.calcKernels();
        double[] ret = new double[2 * this.nk.length];
        Arrays.fill(ret, 0.0);
        int bankCounter = 0;
        while (bankCounter < ret.length / 2) {
            int i = 0;
            while (i < this.nk[bankCounter]) {
                int n = bankCounter;
                ret[n] = ret[n] + this.kernelReal[bankCounter][i] * samples[i];
                int n2 = bankCounter + this.nk.length;
                ret[n2] = ret[n2] + this.kernelImaginary[bankCounter][i] * samples[i];
                ++i;
            }
            ++bankCounter;
        }
        return ret;
    }

    @Override
    public Object clone() {
        return new ConstantQ();
    }

    private void calcFreq(double[] samples, double samplerate) {
        double maxFreq = samplerate / 2.0;
        double minFreq = samplerate / (double)samples.length;
        double carry = Math.log(maxFreq / minFreq);
        carry /= Math.log(2.0);
        int numFields = (int)Math.floor(carry *= 12.0 / this.alpha);
        this.freq = new double[numFields];
        double currentFreq = minFreq;
        int i = 0;
        while (i < numFields) {
            this.freq[i] = currentFreq;
            currentFreq = Math.pow(2.0, this.alpha / 12.0);
            ++i;
        }
    }

    private void calcNk(double[] samples) {
        this.nk = new int[this.freq.length];
        double windowLength = samples.length;
        int i = 0;
        while (i < this.nk.length) {
            this.nk[0] = (int)Math.ceil(windowLength / Math.pow(2.0, (double)i * this.alpha / 12.0));
            ++i;
        }
    }

    private void calcKernels() {
        this.kernelReal = new double[this.nk.length][];
        this.kernelImaginary = new double[this.nk.length][];
        double q = Math.pow(2.0, this.alpha / 12.0) - 1.0;
        double hammingFactor = 0.5434782608695652;
        int i = 0;
        while (i < this.kernelReal.length) {
            this.kernelReal[i] = new double[this.nk[i]];
            this.kernelImaginary[i] = new double[this.nk[i]];
            int j = 0;
            while (j < this.kernelReal[i].length) {
                this.kernelReal[i][j] = hammingFactor + (1.0 - hammingFactor) * Math.cos(Math.PI * 2 * (double)j / (double)this.nk[i]);
                double[] dArray = this.kernelReal[i];
                int n = j;
                dArray[n] = dArray[n] / (double)this.nk[i];
                this.kernelImaginary[i][j] = this.kernelReal[i][j];
                double[] dArray2 = this.kernelReal[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * Math.cos(Math.PI * -2 * q * (double)j / (double)this.nk[i]);
                double[] dArray3 = this.kernelImaginary[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] * Math.sin(Math.PI * -2 * q * (double)j / (double)this.nk[i]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String getElement(int index) throws Exception {
        switch (index) {
            case 0: {
                return Double.toString(this.alpha);
            }
        }
        throw new Exception("INTERNAL ERROR: invalid index " + index + " passed to LPC:getElement()");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        switch (index) {
            case 0: {
                try {
                    double val = Double.parseDouble(value);
                    if (val <= 0.0) {
                        throw new Exception("Alpha must be a positive value");
                    }
                    this.alpha = val;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Alpha value must be a double");
                }
            }
            default: {
                throw new Exception("INTERNAL ERROR: invalid index passed to ConstantQ:setElement");
            }
        }
    }
}

