/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.jAudioTools.DSPMethods;

public class BeatHistogram
extends FeatureExtractor {
    private int number_windows = 256;

    public BeatHistogram() {
        String name = "Beat Histogram";
        String description = "A histogram showing the relative strength of different rhythmic periodicities (tempi) in a signal. Found by calculating the auto-correlation of the RMS.";
        boolean is_sequential = true;
        int dimensions = 0;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[this.number_windows];
        int i = 0;
        while (i < this.dependencies.length) {
            this.dependencies[i] = "Root Mean Square";
            ++i;
        }
        this.offsets = new int[this.number_windows];
        i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] rms = new double[other_feature_values.length];
        int i = 0;
        while (i < rms.length) {
            rms[i] = other_feature_values[i][0];
            ++i;
        }
        double effective_sampling_rate = sampling_rate / (double)rms.length;
        int min_lag = (int)(0.286 * effective_sampling_rate);
        int max_lag = (int)(3.0 * effective_sampling_rate);
        double[] auto_correlation = DSPMethods.getAutoCorrelation(rms, min_lag, max_lag);
        return auto_correlation;
    }

    public void setWindowLength(int n) throws Exception {
        if (n < 2) {
            throw new Exception("BeatHistogram window length must be greater than 1");
        }
        this.number_windows = n;
        this.dependencies = new String[this.number_windows];
        this.offsets = new int[this.number_windows];
        int i = 0;
        while (i < this.number_windows) {
            this.dependencies[i] = "Root Mean Square";
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:getElement");
        }
        return Integer.toString(this.number_windows);
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:setElement");
        }
        try {
            int type = Integer.parseInt(value);
            this.setWindowLength(type);
        }
        catch (Exception e) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    @Override
    public Object clone() {
        BeatHistogram ret = new BeatHistogram();
        ret.number_windows = this.number_windows;
        return ret;
    }
}

