/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.AreaPolynomialApproximation;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class AreaPolynomialApproximationConstantQMFCC
extends FeatureExtractor {
    int windowLength = 50;
    int featureLength = 13;
    int k = 10;
    int l = 5;
    DenseDoubleMatrix2D terms;
    DenseDoubleMatrix2D z;

    public AreaPolynomialApproximationConstantQMFCC() {
        String name = "2D Polynomial Approximation ConstantQ MFCC";
        String description = "coeffecients of 2D polynomial best describing the input matrtix.";
        String[] attributes = new String[]{"horizontal size (window length)", "vertical size (number of feature dimensions)", "number of x (horizontal) terms", "number of y (vertical) terms"};
        this.definition = new FeatureDefinition(name, description, true, 0, attributes);
        this.dependencies = new String[this.windowLength];
        int i = 0;
        while (i < this.dependencies.length) {
            this.dependencies[i] = "ConstantQ-derived MFCC";
            ++i;
        }
        this.offsets = new int[this.windowLength];
        i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = 0 - i;
            ++i;
        }
        this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
        this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
        this.calcTerms(this.terms);
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        if (this.featureLength != other_feature_values[0].length || this.windowLength != other_feature_values.length) {
            this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
            this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
            this.calcTerms(this.terms);
        }
        int i = 0;
        while (i < this.windowLength) {
            int j = 0;
            while (j < this.featureLength) {
                this.z.set(0, this.windowLength * i + j, other_feature_values[i][j]);
                ++j;
            }
            ++i;
        }
        DoubleMatrix2D retMatrix = new Algebra().solve(this.terms, this.z);
        return retMatrix.viewRow(0).toArray();
    }

    @Override
    public void setWindow(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Area Polynomial Approximation window length must be positive");
        }
        this.windowLength = n;
        this.dependencies = new String[this.windowLength];
        this.offsets = new int[this.windowLength];
        int i = 0;
        while (i < this.windowLength) {
            this.dependencies[i] = "Magnitude Spectrum";
            this.offsets[i] = 0 - i;
            ++i;
        }
        this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
        this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
        this.calcTerms(this.terms);
    }

    @Override
    public String getElement(int index) throws Exception {
        switch (index) {
            case 0: {
                return Integer.toString(this.windowLength);
            }
            case 1: {
                return Integer.toString(this.featureLength);
            }
            case 2: {
                return Integer.toString(this.k);
            }
            case 3: {
                return Integer.toString(this.k);
            }
        }
        throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaPolynomialApproximation:getElement");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        switch (index) {
            case 0: {
                try {
                    int val = Integer.parseInt(value);
                    if (val < 1) {
                        throw new Exception("Area Polynomial Approximation window length must be positive");
                    }
                    this.windowLength = val;
                    this.dependencies = new String[this.windowLength];
                    this.offsets = new int[this.windowLength];
                    int i = 0;
                    while (i < this.windowLength) {
                        this.dependencies[i] = "Magnitude Spectrum";
                        this.offsets[i] = 0 - i;
                        ++i;
                    }
                    this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
                    this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
                    this.calcTerms(this.terms);
                    break;
                }
                catch (Exception e) {
                    throw new Exception("horizontal (windowLength) of Area Polynomial Approximation must be an integer");
                }
            }
            case 1: {
                try {
                    int val = Integer.parseInt(value);
                    if (val < 1) {
                        throw new Exception("Area Polynomial Approximation feature dimension length must be positive");
                    }
                    this.featureLength = val;
                    this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
                    this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
                    break;
                }
                catch (Exception e) {
                    throw new Exception("vertical (feature dimensions) of Area Polynomial Approximation must be an integer");
                }
            }
            case 2: {
                try {
                    int val = Integer.parseInt(value);
                    if (val < 1) {
                        throw new Exception("Number of x terms in Area Polynomial Approximation must be positive");
                    }
                    this.k = val;
                    this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
                    this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
                    this.calcTerms(this.terms);
                    break;
                }
                catch (Exception e) {
                    throw new Exception("Number of x terms in Area Polynomial Approximation must be an integer");
                }
            }
            case 3: {
                try {
                    int val = Integer.parseInt(value);
                    if (val < 1) {
                        throw new Exception("Number of y terms in Area Polynomial Approximation must be positive");
                    }
                    this.l = val;
                    this.terms = new DenseDoubleMatrix2D(this.k * this.l, this.windowLength * this.featureLength);
                    this.z = new DenseDoubleMatrix2D(1, this.featureLength * this.windowLength);
                    this.calcTerms(this.terms);
                    break;
                }
                catch (Exception e) {
                    throw new Exception("Number of y terms of Area Polynomial Approximation must be an integer");
                }
            }
            default: {
                throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaPolynomialApproximation:getElement");
            }
        }
    }

    @Override
    public Object clone() {
        AreaPolynomialApproximation ret = new AreaPolynomialApproximation();
        return ret;
    }

    private void calcTerms(DoubleMatrix2D terms) {
        terms.assign(0.0);
        int x = 0;
        while (x < this.windowLength) {
            int y = 0;
            while (y < this.featureLength) {
                int i = 0;
                while (i < this.k) {
                    int j = 0;
                    while (j < this.l) {
                        terms.set(this.l * i + j, this.featureLength * x + y, Math.pow(x, i) * Math.pow(y, j));
                        ++j;
                    }
                    ++i;
                }
                ++y;
            }
            ++x;
        }
    }
}

