/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.AreaMoments;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.util.Arrays;

public class AreaMomentsMFCC
extends FeatureExtractor {
    int lengthOfWindow = 10;
    double x;
    double y;
    double x2;
    double xy;
    double y2;
    double x3;
    double x2y;
    double xy2;
    double y3;

    public AreaMomentsMFCC() {
        String name = "Area Method of Moments of MFCCs";
        String description = "2D statistical method of moments of MFCCs";
        String[] attributes = new String[]{"Area Method of Moments Window Length"};
        this.definition = new FeatureDefinition(name, description, true, 10, attributes);
        this.dependencies = new String[this.lengthOfWindow];
        int i = 0;
        while (i < this.dependencies.length) {
            this.dependencies[i] = "MFCC";
            ++i;
        }
        this.offsets = new int[this.lengthOfWindow];
        i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        int j;
        double[] ret = new double[10];
        double sum = 0.0;
        int i = 0;
        while (i < other_feature_values.length) {
            j = 0;
            while (j < other_feature_values[i].length) {
                sum += other_feature_values[i][j];
                ++j;
            }
            ++i;
        }
        if (sum == 0.0) {
            Arrays.fill(ret, 0.0);
            return ret;
        }
        i = 0;
        while (i < other_feature_values.length) {
            j = 0;
            while (j < other_feature_values[i].length) {
                double tmp = other_feature_values[i][j] / sum;
                this.x += tmp * (double)i;
                this.y += tmp * (double)j;
                this.x2 += tmp * (double)i * (double)i;
                this.xy += tmp * (double)i * (double)j;
                this.y2 += tmp * (double)j * (double)j;
                this.x3 += tmp * (double)i * (double)i * (double)i;
                this.x2y += tmp * (double)i * (double)i * (double)j;
                this.xy2 += tmp * (double)i * (double)j * (double)j;
                this.y3 += tmp * (double)j * (double)j * (double)j;
                ++j;
            }
            ++i;
        }
        ret[0] = sum;
        ret[1] = this.x;
        ret[2] = this.y;
        ret[3] = this.x2 - this.x * this.x;
        ret[4] = this.xy - this.x * this.y;
        ret[5] = this.y2 - this.y * this.y;
        ret[6] = 2.0 * Math.pow(this.x, 3.0) - 3.0 * this.x * this.x2 + this.x3;
        ret[7] = 2.0 * this.x * this.xy - this.y * this.x2 + this.x2 * this.y;
        ret[8] = 2.0 * this.y * this.xy - this.x * this.y2 + this.y2 * this.x;
        ret[9] = 2.0 * Math.pow(this.y, 3.0) - 3.0 * this.y * this.y2 + this.y3;
        return ret;
    }

    @Override
    public void setWindow(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Area Method of Moment's Window length must be two or greater");
        }
        this.lengthOfWindow = n;
        this.dependencies = new String[this.lengthOfWindow];
        this.offsets = new int[this.lengthOfWindow];
        int i = 0;
        while (i < this.lengthOfWindow) {
            this.dependencies[i] = "Magnitude Spectrum";
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:getElement");
        }
        return Integer.toString(this.lengthOfWindow);
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:setElement");
        }
        try {
            int type = Integer.parseInt(value);
            this.setWindow(type);
        }
        catch (Exception e) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    @Override
    public Object clone() {
        AreaMoments ret = new AreaMoments();
        ret.lengthOfWindow = this.lengthOfWindow;
        return ret;
    }
}

