/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class StandardDeviation
extends Aggregator {
    int feature = -1;

    public StandardDeviation() {
        this.metadata = new AggregatorDefinition("Standard Deviation", "Standard Deviation of the window-by-window data", true, null);
    }

    @Override
    public void aggregate(double[][][] values) {
        if (values[values.length - 1][this.feature] == null) {
            this.definition.dimensions = 1;
            this.result = new double[]{0.0};
        } else {
            int max;
            this.definition.dimensions = max = values[values.length - 1][this.feature].length;
            this.result = new double[max];
            int i = 0;
            while (i < max) {
                int count = 0;
                double average = 0.0;
                int j = 0;
                while (j < values.length) {
                    if (values[j][this.feature] != null && values[j][this.feature].length > i) {
                        average += values[j][this.feature][i];
                        ++count;
                    }
                    ++j;
                }
                if (count < 2) {
                    this.result[i] = 0.0;
                } else {
                    average /= (double)count;
                    j = 0;
                    while (j < values.length) {
                        if (values[j][this.feature] != null && values[j][this.feature].length > i) {
                            int n = i;
                            this.result[n] = this.result[n] + Math.pow(values[j][this.feature][i] - average, 2.0);
                        }
                        ++j;
                    }
                    this.result[i] = Math.sqrt(this.result[i] / ((double)count - 1.0));
                }
                ++i;
            }
        }
    }

    @Override
    public Object clone() {
        return new StandardDeviation();
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    @Override
    public String[] getFeaturesToApply() {
        return null;
    }

    @Override
    public void init(int[] featureIndecis) throws Exception {
        this.feature = featureIndecis[0];
    }

    @Override
    public void setSource(FeatureExtractor feature) {
        FeatureDefinition this_def = feature.getFeatureDefinition();
        this.definition = new FeatureDefinition(String.valueOf(this_def.name) + " Overall Standard Deviation", String.valueOf(this_def.description) + LINE_SEP + "This is the overall standard deviation over all windows.", this_def.is_sequential, this_def.dimensions);
    }
}

