/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ActiveAggTableModel;
import jAudioFeatureExtractor.AggEditorFrame;
import jAudioFeatureExtractor.AggListTableModel;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Aggregators.Mean;
import jAudioFeatureExtractor.Controller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AggregatorFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane ActiveAggList = null;
    private JTable ActiveAggTable = null;
    private JScrollPane AggList = null;
    private JTable AggListTable = null;
    private JPanel AggButtonPanel = null;
    private JButton AggAdd = null;
    private JButton AggRemove = null;
    private JButton AggEdit = null;
    private AggEditorFrame aggEditorFrame = null;
    private Controller controller;
    private JButton DoneButton = null;
    private JButton Abort = null;

    public AggregatorFrame(Controller c) {
        this.controller = c;
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("Aggregators");
        this.setBounds(new Rectangle(0, 22, 1000, 1000));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getActiveAggList(), "West");
            this.jContentPane.add((Component)this.getAggList(), "East");
            this.jContentPane.add((Component)this.getAggButtonPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getActiveAggList() {
        if (this.ActiveAggList == null) {
            this.ActiveAggList = new JScrollPane();
            this.ActiveAggList.setViewportView(this.getActiveAggTable());
        }
        return this.ActiveAggList;
    }

    private JTable getActiveAggTable() {
        if (this.ActiveAggTable == null) {
            this.ActiveAggTable = new JTable();
            this.controller.activeAgg_ = new ActiveAggTableModel();
            this.controller.activeAgg_.init(this.controller);
            this.ActiveAggTable.setModel(this.controller.activeAgg_);
            this.ActiveAggTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = AggregatorFrame.this.ActiveAggTable.getSelectedRow()) >= 0) {
                        AggregatorFrame.this.aggEditorFrame = new AggEditorFrame(((AggregatorFrame)AggregatorFrame.this).controller.activeAgg_.getAggregator(row), AggregatorFrame.this.controller);
                        AggregatorFrame.this.aggEditorFrame.setVisible(true);
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).setAggregator(row, AggregatorFrame.this.aggEditorFrame.getAggregator(), AggregatorFrame.this.aggEditorFrame.isEdited());
                    }
                }
            });
        }
        return this.ActiveAggTable;
    }

    private JScrollPane getAggList() {
        if (this.AggList == null) {
            this.AggList = new JScrollPane();
            this.AggList.setViewportView(this.getAggListTable());
        }
        return this.AggList;
    }

    private JTable getAggListTable() {
        if (this.AggListTable == null) {
            this.AggListTable = new JTable();
            this.controller.aggList_ = new AggListTableModel();
            this.controller.aggList_.init(this.controller.dm_.aggregatorMap);
            this.AggListTable.setModel(this.controller.aggList_);
            this.AggListTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int[] row = AggregatorFrame.this.AggListTable.getSelectedRows();
                        int i = 0;
                        while (i < row.length) {
                            AggListTableModel list = (AggListTableModel)AggregatorFrame.this.AggListTable.getModel();
                            Aggregator prototype = list.getAggregator(row[i]);
                            Aggregator newAgg = (Aggregator)prototype.clone();
                            ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).addAggregator(newAgg);
                            ++i;
                        }
                    }
                }
            });
        }
        return this.AggListTable;
    }

    private JPanel getAggButtonPanel() {
        if (this.AggButtonPanel == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.AggButtonPanel = new JPanel();
            this.AggButtonPanel.setLayout(new GridBagLayout());
            this.AggButtonPanel.add((Component)this.getAggAdd(), gridBagConstraints);
            this.AggButtonPanel.add((Component)this.getAggRemove(), gridBagConstraints1);
            this.AggButtonPanel.add((Component)this.getAggEdit(), gridBagConstraints2);
            this.AggButtonPanel.add((Component)this.getDoneButton(), gridBagConstraints11);
            this.AggButtonPanel.add((Component)this.getAbort(), gridBagConstraints21);
        }
        return this.AggButtonPanel;
    }

    private JButton getAggAdd() {
        if (this.AggAdd == null) {
            this.AggAdd = new JButton();
            this.AggAdd.setText("Add");
            this.AggAdd.setToolTipText("Add a new Aggregator to be applied");
            this.AggAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AggregatorFrame.this.AggListTable.getSelectedRow();
                    if (row != -1) {
                        AggListTableModel list = (AggListTableModel)AggregatorFrame.this.AggListTable.getModel();
                        Aggregator prototype = list.getAggregator(row);
                        Aggregator newAgg = (Aggregator)prototype.clone();
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).addAggregator(newAgg);
                    }
                    System.out.println("actionPerformed()");
                }
            });
        }
        return this.AggAdd;
    }

    private JButton getAggRemove() {
        if (this.AggRemove == null) {
            this.AggRemove = new JButton();
            this.AggRemove.setText("Remove");
            this.AggRemove.setToolTipText("Remove an aggregator that has been previously defined");
            this.AggRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AggregatorFrame.this.ActiveAggTable.getSelectedRow();
                    if (row >= 0) {
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).removeAggregator(row);
                    }
                }
            });
        }
        return this.AggRemove;
    }

    private JButton getAggEdit() {
        if (this.AggEdit == null) {
            this.AggEdit = new JButton();
            this.AggEdit.setText("Edit");
            this.AggEdit.setToolTipText("Edit the properities of the defined aggregator");
            this.AggEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AggregatorFrame.this.ActiveAggTable.getSelectedRow();
                    if (row != -1) {
                        AggregatorFrame.this.aggEditorFrame = new AggEditorFrame(((AggregatorFrame)AggregatorFrame.this).controller.activeAgg_.getAggregator(row), AggregatorFrame.this.controller);
                        AggregatorFrame.this.aggEditorFrame.setVisible(true);
                        ((ActiveAggTableModel)AggregatorFrame.this.ActiveAggTable.getModel()).setAggregator(row, AggregatorFrame.this.aggEditorFrame.getAggregator(), AggregatorFrame.this.aggEditorFrame.isEdited());
                    }
                }
            });
        }
        return this.AggEdit;
    }

    private JButton getDoneButton() {
        if (this.DoneButton == null) {
            this.DoneButton = new JButton();
            this.DoneButton.setText("Save");
            this.DoneButton.setToolTipText("Save and exit aggregator editing.");
            this.DoneButton.addActionListener(this);
        }
        return this.DoneButton;
    }

    private JButton getAbort() {
        if (this.Abort == null) {
            this.Abort = new JButton();
            this.Abort.setText("Cancel");
            this.Abort.setToolTipText("Exit without saving.");
            this.Abort.addActionListener(this);
        }
        return this.Abort;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.DoneButton) {
            if (this.controller.activeAgg_.getAggregator() != null && this.controller.activeAgg_.getAggregator().length > 0) {
                this.controller.dm_.aggregators = this.controller.activeAgg_.getAggregator();
                this.setVisible(false);
            } else {
                this.controller.dm_.aggregators = new Aggregator[]{new Mean()};
            }
        } else if (event.getSource() == this.Abort) {
            this.setVisible(false);
        }
    }
}

