/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.Controller;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class AddBatchGUI
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private Controller controller;
    JButton saveBatch;
    JButton cancel;
    private JLabel nameLabel;
    private JTextArea nameArea;
    private Batch batch;

    public AddBatchGUI(Controller c, Batch b) {
        this.controller = c;
        this.batch = b;
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        this.nameLabel = new JLabel("Batch Name");
        this.nameLabel.setHorizontalAlignment(4);
        this.nameArea = new JTextArea("", 1, 20);
        this.nameArea.setColumns(15);
        this.saveBatch = new JButton("Save");
        this.saveBatch.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.setLayout(new GridLayout(2, 2, 6, 11));
        this.add(this.nameLabel);
        this.add(this.nameArea);
        this.add(this.saveBatch);
        this.add(this.cancel);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.saveBatch)) {
            this.save();
        } else if (e.getSource().equals(this.cancel)) {
            this.setVisible(false);
        }
    }

    protected void save() {
        int count = 0;
        int same = -1;
        if (this.nameArea.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Batch names cannot be empty", "ERROR", 0);
        } else {
            this.batch.setName(this.nameArea.getText());
            for (Batch b : this.controller.batches) {
                if (b.getName().equals(this.nameArea.getText())) {
                    same = count;
                }
                ++count;
            }
            if (same != -1) {
                int state = JOptionPane.showConfirmDialog(this, "This will overwrite an existing batch.  Continue Anyways?", "Confirm Overwrite", 0);
                if (state == 0) {
                    System.out.println(same);
                    this.controller.batches.remove(same);
                    this.controller.removeBatch.remove(same);
                    this.controller.viewBatch.remove(same);
                    this.add(this.batch);
                }
            } else {
                this.add(this.batch);
            }
            this.setVisible(false);
        }
    }

    private void add(Batch b) {
        this.controller.batches.add(b);
        if (!this.controller.removeBatch.isEnabled()) {
            this.controller.removeBatch.setEnabled(true);
        }
        JMenuItem remove = new JMenuItem(b.getName());
        remove.addActionListener(this.controller.removeBatchAction);
        this.controller.removeBatch.add(remove);
        if (!this.controller.viewBatch.isEnabled()) {
            this.controller.viewBatch.setEnabled(true);
        }
        JMenuItem view = new JMenuItem(b.getName());
        view.addActionListener(this.controller.viewBatchAction);
        this.controller.viewBatch.add(view);
    }
}

