/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.DataTypes.SegmentedClassification;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParseClassificationsFileHandler
extends ParseFileHandler {
    private LinkedList<SegmentedClassification> root_classifications;
    private SegmentedClassification current_root_classification;
    private LinkedList<SegmentedClassification> subset_classifications;
    private SegmentedClassification current_subset_classification;
    private LinkedList<String> classes;
    private LinkedList<String> meta_data_keys;
    private LinkedList<String> meta_data_info;
    private int tag_identifier;
    private int count;

    @Override
    public void startDocument() {
        this.root_classifications = new LinkedList();
        this.current_root_classification = null;
        this.subset_classifications = null;
        this.current_subset_classification = null;
        this.classes = null;
        this.meta_data_keys = null;
        this.meta_data_info = null;
        this.count = 0;
    }

    @Override
    public void startElement(String namespace, String name, String qName, Attributes atts) throws SAXException {
        if (this.count == 0 && !name.equals("classifications_file") && !qName.equals("classifications_file")) {
            throw new SAXException("\n\nIt is in reality of the type " + name + ".");
        }
        ++this.count;
        this.tag_identifier = 0;
        if (name.equals("data_set") || qName.equals("data_set")) {
            this.current_root_classification = new SegmentedClassification();
            this.root_classifications.add(this.current_root_classification);
        } else if (name.equals("section") || qName.equals("section")) {
            if (this.subset_classifications == null) {
                this.subset_classifications = new LinkedList();
            }
            this.current_subset_classification = new SegmentedClassification();
            this.subset_classifications.add(this.current_subset_classification);
        } else if (name.equals("class") || qName.equals("class")) {
            if (this.classes == null) {
                this.classes = new LinkedList();
            }
            this.tag_identifier = 1;
        } else if (name.equals("misc_info") || qName.equals("misc_info")) {
            if (this.meta_data_keys == null) {
                this.meta_data_keys = new LinkedList();
                this.meta_data_info = new LinkedList();
            }
            this.meta_data_keys.add(atts.getValue(0));
            this.tag_identifier = 2;
        } else if (name.equals("data_set_id") || qName.equals("data_set_id")) {
            this.tag_identifier = 3;
        } else if (name.equals("role") || qName.equals("role")) {
            this.tag_identifier = 4;
        } else if (name.equals("start") || qName.equals("start")) {
            this.tag_identifier = 5;
        } else if (name.equals("stop") || qName.equals("stop")) {
            this.tag_identifier = 6;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String contents = new String(ch, start, length);
        if (this.tag_identifier == 1) {
            this.classes.add(contents);
        } else if (this.tag_identifier == 2) {
            this.meta_data_info.add(contents);
        } else if (this.tag_identifier == 3) {
            this.current_root_classification.identifier = contents;
        } else if (this.tag_identifier == 4) {
            this.current_root_classification.role = contents;
        } else if (this.tag_identifier == 5) {
            this.current_subset_classification.start = Double.parseDouble(contents);
        } else if (this.tag_identifier == 6) {
            this.current_subset_classification.stop = Double.parseDouble(contents);
        }
    }

    @Override
    public void endElement(String namespace, String name, String qName) {
        if (name.equals("data_set")) {
            int i;
            String[] str;
            Object[] obj;
            if (this.classes != null) {
                obj = this.classes.toArray();
                str = new String[obj.length];
                i = 0;
                while (i < str.length) {
                    str[i] = (String)obj[i];
                    ++i;
                }
                this.current_root_classification.classifications = str;
            }
            if (this.meta_data_keys != null) {
                obj = this.meta_data_keys.toArray();
                str = new String[obj.length];
                i = 0;
                while (i < str.length) {
                    str[i] = (String)obj[i];
                    ++i;
                }
                this.current_root_classification.misc_info_key = str;
            }
            if (this.meta_data_info != null) {
                obj = this.meta_data_info.toArray();
                str = new String[obj.length];
                i = 0;
                while (i < str.length) {
                    str[i] = (String)obj[i];
                    ++i;
                }
                this.current_root_classification.misc_info_info = str;
            }
            if (this.subset_classifications != null) {
                obj = this.subset_classifications.toArray();
                SegmentedClassification[] sc = new SegmentedClassification[obj.length];
                i = 0;
                while (i < sc.length) {
                    sc[i] = (SegmentedClassification)obj[i];
                    ++i;
                }
                this.current_root_classification.sub_classifications = sc;
            }
            this.classes = null;
            this.meta_data_keys = null;
            this.meta_data_info = null;
            this.subset_classifications = null;
            this.current_root_classification = null;
        } else if (name.equals("section")) {
            if (this.classes != null) {
                Object[] obj = this.classes.toArray();
                String[] str = new String[obj.length];
                int i = 0;
                while (i < str.length) {
                    str[i] = (String)obj[i];
                    ++i;
                }
                this.current_subset_classification.classifications = str;
            }
            this.classes = null;
            this.current_subset_classification = null;
        }
    }

    @Override
    public void endDocument() {
        this.parsed_file_contents = this.root_classifications.toArray();
    }
}

