/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeatureListHandler
extends ParseFileHandler {
    public static final int FEATURE_LIST = 0;
    public static final int FEATURE = 1;
    public static final int CLASS = 2;
    public static final int ON = 4;
    public static final int PLUGIN_LOCATION = 5;
    public static final int AGGREGATOR = 6;
    public boolean firstTag = true;
    LinkedList<Boolean> b;
    LinkedList<FeatureExtractor> f;
    LinkedList<Aggregator> a;
    URLClassLoader classLoader;
    int tagType = -1;
    boolean isOn = false;
    String className = "";

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.tagType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.className = new String(ch, start, length);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                try {
                    URL[] pluginURL = new URL[]{new URL(new String(ch, start, length))};
                    this.classLoader = URLClassLoader.newInstance(pluginURL, Thread.currentThread().getContextClassLoader());
                    break;
                }
                catch (MalformedURLException e) {
                    throw new SAXException("Plugin location not a valid URL:" + new String(ch, start, length));
                }
            }
            case 6: {
                this.className = new String(ch, start, length);
                break;
            }
            default: {
                if (this.firstTag) break;
                throw new SAXException("Unknown tagType found (" + this.tagType + ") - content='" + new String(ch, start, length) + "'");
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsed_file_contents = new Object[3];
        this.parsed_file_contents[0] = this.f;
        this.parsed_file_contents[1] = this.b;
        this.parsed_file_contents[2] = this.a;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("featureList") || qName.equals("featureList")) {
            this.tagType = -1;
        } else if (localName.equals("feature") || localName.equals("metaFeature") || qName.equals("feature") || qName.equals("metaFeature")) {
            try {
                Class<?> c = null;
                c = Class.forName(this.className, true, this.classLoader);
                Object o = c.getConstructor(new Class[0]).newInstance(null);
                this.f.add((FeatureExtractor)o);
                if (this.isOn) {
                    this.b.add(true);
                } else {
                    this.b.add(false);
                }
                this.isOn = false;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new SAXException("<IllegalAccessException> Class '" + this.className + "' does not have a zero argument constructor");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new SAXException("<SecurityException> Class '" + this.className + "' does not have permission to create a new object of that class");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new SAXException("<ClassNotFoundException> Class '" + this.className + "' does not exist in the path.");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new SAXException("<InstantiationException> Class '" + this.className + "' is either abstract or an interface");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new SAXException("<IllegalAccessException> Class '" + this.className + "' could not be created");
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new SAXException("<InvocationTargetException> Class '" + this.className + "' threw an execption in its constructor");
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new SAXException("<NoSuchMethodException> Class '" + this.className + "' could not find its constructor");
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                throw new SAXException("<ClassCastException> Class '" + this.className + "' was succesfully created but was not a subclass of FeatureExtractor: " + e.getMessage());
            }
            this.tagType = 0;
        } else if (localName.equals("class") || qName.equals("class")) {
            this.tagType = 1;
        } else if (localName.equals("on") || qName.equals("on")) {
            this.tagType = 1;
        } else if (localName.equals("pluginFolder") || qName.equals("pluginFolder")) {
            this.tagType = 0;
        } else if (localName.equals("aggregator") || qName.equals("aggregator")) {
            try {
                Class<?> c = null;
                c = Class.forName(this.className, true, this.classLoader);
                Object o = c.getConstructor(new Class[0]).newInstance(null);
                this.a.add((Aggregator)o);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new SAXException("<IllegalAccessException> Class '" + this.className + "' does not have a zero argument constructor");
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new SAXException("<SecurityException> Class '" + this.className + "' does not have permission to create a new object of that class");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new SAXException("<ClassNotFoundException> Class '" + this.className + "' does not exist in the path.");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new SAXException("<InstantiationException> Class '" + this.className + "' is either abstract or an interface");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new SAXException("<IllegalAccessException> Class '" + this.className + "' could not be created");
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new SAXException("<InvocationTargetException> Class '" + this.className + "' threw an execption in its constructor");
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new SAXException("<NoSuchMethodException> Class '" + this.className + "' could not find its constructor");
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                throw new SAXException("<ClassCastException> Class '" + this.className + "' was succesfully created but was not a subclass of Aggregator: " + e.getMessage());
            }
            this.tagType = 0;
        } else {
            throw new SAXException("Unknown tag type " + this.tagType + " discovered - content='" + localName + "'");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.f = new LinkedList();
        this.b = new LinkedList();
        this.a = new LinkedList();
        this.classLoader = new URLClassLoader(new URL[0]);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.firstTag = false;
        if (localName.equals("featureList") || qName.equals("featureList")) {
            this.tagType = 0;
        } else if (localName.equals("feature") || qName.equals("feature")) {
            this.tagType = 1;
        } else if (localName.equals("class") || qName.equals("class")) {
            this.tagType = 2;
        } else if (localName.equals("on") || qName.equals("on")) {
            this.tagType = 4;
            this.isOn = true;
        } else if (localName.equals("pluginFolder") || qName.equals("pluginFolder")) {
            this.tagType = 5;
        } else if (localName.equals("aggregator") || qName.equals("aggregator")) {
            this.tagType = 6;
        } else {
            throw new SAXException("Unknown tagType " + this.tagType + " discovered - content='" + localName + "'" + "'" + qName + "'" + uri + "'");
        }
    }
}

