/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.matrix.impl.FormerFactory;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.DynamicBin1D;

public class BinFunctions1D {
    public static final BinFunctions1D functions = new BinFunctions1D();
    public static final BinFunction1D max = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.max();
        }

        @Override
        public final String name() {
            return "Max";
        }
    };
    public static final BinFunction1D mean = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.mean();
        }

        @Override
        public final String name() {
            return "Mean";
        }
    };
    public static final BinFunction1D median = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.median();
        }

        @Override
        public final String name() {
            return "Median";
        }
    };
    public static final BinFunction1D min = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.min();
        }

        @Override
        public final String name() {
            return "Min";
        }
    };
    public static final BinFunction1D rms = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.rms();
        }

        @Override
        public final String name() {
            return "RMS";
        }
    };
    public static final BinFunction1D size = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.size();
        }

        @Override
        public final String name() {
            return "Size";
        }
    };
    public static final BinFunction1D stdDev = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.standardDeviation();
        }

        @Override
        public final String name() {
            return "StdDev";
        }
    };
    public static final BinFunction1D sum = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.sum();
        }

        @Override
        public final String name() {
            return "Sum";
        }
    };
    public static final BinFunction1D sumLog = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.sumOfLogarithms();
        }

        @Override
        public final String name() {
            return "SumLog";
        }
    };
    public static final BinFunction1D geometricMean = new BinFunction1D(){

        @Override
        public final double apply(DynamicBin1D bin) {
            return bin.geometricMean();
        }

        @Override
        public final String name() {
            return "GeomMean";
        }
    };

    protected BinFunctions1D() {
    }

    public static BinFunction1D quantile(final double percentage) {
        return new BinFunction1D(){

            @Override
            public final double apply(DynamicBin1D bin) {
                return bin.quantile(percentage);
            }

            @Override
            public final String name() {
                return String.valueOf(new FormerFactory().create("%1.2G").form(percentage * 100.0)) + "% Q.";
            }
        };
    }
}

