/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.map.OpenIntDoubleHashMap;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SelectedSparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

public class SparseDoubleMatrix1D
extends DoubleMatrix1D {
    protected AbstractIntDoubleMap elements;

    public SparseDoubleMatrix1D(double[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseDoubleMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseDoubleMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenIntDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseDoubleMatrix1D(int size, AbstractIntDoubleMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix1D assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public double getQuick(int index) {
        return this.elements.get(this.zero + index * this.stride);
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D otherMatrix = (SelectedSparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D otherMatrix = (SparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int index, double value) {
        int i = this.zero + index * this.stride;
        if (value == 0.0) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseDoubleMatrix1D(this.elements, offsets);
    }
}

