/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix1D;
import cern.colt.matrix.impl.SelectedDenseObjectMatrix2D;

public class DenseObjectMatrix2D
extends ObjectMatrix2D {
    protected Object[] elements;

    public DenseObjectMatrix2D(Object[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseObjectMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new Object[rows * columns];
    }

    protected DenseObjectMatrix2D(int rows, int columns, Object[] elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public ObjectMatrix2D assign(Object[][] values) {
        if (this.isNoView) {
            if (values.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
            }
            int i = this.columns * (this.rows - 1);
            int row = this.rows;
            while (--row >= 0) {
                Object[] currentRow = values[row];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                i -= this.columns;
            }
        } else {
            super.assign(values);
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectFunction function) {
        Object[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        int index = this.index(0, 0);
        int cs = this.columnStride;
        int rs = this.rowStride;
        int row = this.rows;
        while (--row >= 0) {
            int i = index;
            int column = this.columns;
            while (--column >= 0) {
                elems[i] = function.apply(elems[i]);
                i += cs;
            }
            index += rs;
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        if (!(source instanceof DenseObjectMatrix2D)) {
            return super.assign(source);
        }
        DenseObjectMatrix2D other = (DenseObjectMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            ObjectMatrix2D c = other.copy();
            if (!(c instanceof DenseObjectMatrix2D)) {
                return super.assign(other);
            }
            other = (DenseObjectMatrix2D)c;
        }
        Object[] elems = this.elements;
        Object[] otherElems = other.elements;
        if (this.elements == null || otherElems == null) {
            throw new InternalError();
        }
        int cs = this.columnStride;
        int ocs = other.columnStride;
        int rs = this.rowStride;
        int ors = other.rowStride;
        int otherIndex = other.index(0, 0);
        int index = this.index(0, 0);
        int row = this.rows;
        while (--row >= 0) {
            int i = index;
            int j = otherIndex;
            int column = this.columns;
            while (--column >= 0) {
                elems[i] = otherElems[j];
                i += cs;
                j += ocs;
            }
            index += rs;
            otherIndex += ors;
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D y, ObjectObjectFunction function) {
        if (!(y instanceof DenseObjectMatrix2D)) {
            return super.assign(y, function);
        }
        DenseObjectMatrix2D other = (DenseObjectMatrix2D)y;
        this.checkShape(y);
        Object[] elems = this.elements;
        Object[] otherElems = other.elements;
        if (elems == null || otherElems == null) {
            throw new InternalError();
        }
        int cs = this.columnStride;
        int ocs = other.columnStride;
        int rs = this.rowStride;
        int ors = other.rowStride;
        int otherIndex = other.index(0, 0);
        int index = this.index(0, 0);
        int row = this.rows;
        while (--row >= 0) {
            int i = index;
            int j = otherIndex;
            int column = this.columns;
            while (--column >= 0) {
                elems[i] = function.apply(elems[i], otherElems[j]);
                i += cs;
                j += ocs;
            }
            index += rs;
            otherIndex += ors;
        }
        return this;
    }

    @Override
    public Object getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D otherMatrix = (SelectedDenseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D otherMatrix = (DenseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix1D like1D(int size) {
        return new DenseObjectMatrix1D(size);
    }

    @Override
    protected ObjectMatrix1D like1D(int size, int zero, int stride) {
        return new DenseObjectMatrix1D(size, this.elements, zero, stride);
    }

    @Override
    public void setQuick(int row, int column, Object value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseObjectMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

