/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.PersistentObject;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;

public class ObjectFactory2D
extends PersistentObject {
    public static final ObjectFactory2D dense = new ObjectFactory2D();
    public static final ObjectFactory2D sparse = new ObjectFactory2D();

    protected ObjectFactory2D() {
    }

    public ObjectMatrix2D appendColumns(ObjectMatrix2D A, ObjectMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        ObjectMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public ObjectMatrix2D appendRows(ObjectMatrix2D A, ObjectMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        ObjectMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    protected static void checkRectangularShape(ObjectMatrix2D[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(Object[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public ObjectMatrix2D compose(ObjectMatrix2D[][] parts) {
        int row;
        ObjectFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        ObjectMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                ObjectMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                ObjectMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        ObjectMatrix2D matrix = this.make(resultRows, resultCols);
        int r = 0;
        int row3 = 0;
        while (row3 < rows) {
            int c = 0;
            int column4 = 0;
            while (column4 < columns) {
                ObjectMatrix2D part = parts[row3][column4];
                if (part != null) {
                    matrix.viewPart(r, c, part.rows(), part.columns()).assign(part);
                }
                c += maxWidths[column4];
                ++column4;
            }
            r += maxHeights[row3];
            ++row3;
        }
        return matrix;
    }

    public ObjectMatrix2D composeDiagonal(ObjectMatrix2D A, ObjectMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        ObjectMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public ObjectMatrix2D composeDiagonal(ObjectMatrix2D A, ObjectMatrix2D B, ObjectMatrix2D C) {
        ObjectMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public void decompose(ObjectMatrix2D[][] parts, ObjectMatrix2D matrix) {
        int row;
        ObjectFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                ObjectMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                ObjectMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int r = 0;
        int row3 = 0;
        while (row3 < rows) {
            int c = 0;
            int column4 = 0;
            while (column4 < columns) {
                ObjectMatrix2D part = parts[row3][column4];
                if (part != null) {
                    part.assign(matrix.viewPart(r, c, part.rows(), part.columns()));
                }
                c += maxWidths[column4];
                ++column4;
            }
            r += maxHeights[row3];
            ++row3;
        }
    }

    public ObjectMatrix2D diagonal(ObjectMatrix1D vector) {
        int size = vector.size();
        ObjectMatrix2D diag = this.make(size, size);
        int i = size;
        while (--i >= 0) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public ObjectMatrix1D diagonal(ObjectMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        ObjectMatrix1D diag = this.make1D(min);
        int i = min;
        while (--i >= 0) {
            diag.setQuick(i, A.getQuick(i, i));
        }
        return diag;
    }

    public ObjectMatrix2D make(Object[][] values) {
        if (this == sparse) {
            return new SparseObjectMatrix2D(values);
        }
        return new DenseObjectMatrix2D(values);
    }

    public ObjectMatrix2D make(Object[] values, int rows) {
        int columns;
        int n = columns = rows != 0 ? values.length / rows : 0;
        if (rows * columns != values.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        ObjectMatrix2D matrix = this.make(rows, columns);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                matrix.setQuick(row, column, values[row + column * rows]);
                ++column;
            }
            ++row;
        }
        return matrix;
    }

    public ObjectMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseObjectMatrix2D(rows, columns);
        }
        return new DenseObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix2D make(int rows, int columns, Object initialValue) {
        if (initialValue == null) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected ObjectMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public ObjectMatrix2D repeat(ObjectMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        ObjectMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = rowRepeat;
        while (--i >= 0) {
            int j = columnRepeat;
            while (--j >= 0) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
            }
        }
        return matrix;
    }
}

