/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import jogamp.opengl.util.pngj.FilterType;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngHelper;
import jogamp.opengl.util.pngj.PngIDatChunkInputStream;
import jogamp.opengl.util.pngj.PngjInputException;
import jogamp.opengl.util.pngj.PngjUnsupportedException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkList;
import jogamp.opengl.util.pngj.chunks.ChunkLoadBehaviour;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngMetadata;

public class PngReader {
    public final ImageInfo imgInfo;
    protected final String filename;
    private static int MAX_BYTES_CHUNKS_TO_LOAD = 640000;
    private ChunkLoadBehaviour chunkLoadBehaviour = ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS;
    private final InputStream is;
    private InflaterInputStream idatIstream;
    private PngIDatChunkInputStream iIdatCstream;
    protected int currentChunkGroup = -1;
    protected int rowNum = -1;
    private int offset = 0;
    private int bytesChunksLoaded;
    protected ImageLine imgLine;
    protected byte[] rowb = null;
    protected byte[] rowbprev = null;
    protected byte[] rowbfilter = null;
    private final ChunkList chunksList;
    private final PngMetadata metadata;

    public PngReader(InputStream inputStream, String string) {
        this.filename = string == null ? "" : string;
        this.is = inputStream;
        this.chunksList = new ChunkList(null);
        this.metadata = new PngMetadata(this.chunksList, true);
        byte[] byArray = new byte[PngHelper.pngIdBytes.length];
        PngHelper.readBytes(this.is, byArray, 0, byArray.length);
        this.offset += byArray.length;
        if (!Arrays.equals(byArray, PngHelper.pngIdBytes)) {
            throw new PngjInputException("Bad PNG signature");
        }
        this.currentChunkGroup = 0;
        int n = PngHelper.readInt4(this.is);
        this.offset += 4;
        if (n != 13) {
            throw new RuntimeException("IDHR chunk len != 13 ?? " + n);
        }
        byte[] byArray2 = new byte[4];
        PngHelper.readBytes(this.is, byArray2, 0, 4);
        if (!Arrays.equals(byArray2, ChunkHelper.b_IHDR)) {
            throw new PngjInputException("IHDR not found as first chunk??? [" + ChunkHelper.toString(byArray2) + "]");
        }
        this.offset += 4;
        ChunkRaw chunkRaw = new ChunkRaw(n, byArray2, true);
        String string2 = ChunkHelper.toString(byArray2);
        this.offset += chunkRaw.readChunkData(this.is);
        PngChunkIHDR pngChunkIHDR = (PngChunkIHDR)this.addChunkToList(chunkRaw);
        boolean bl = (pngChunkIHDR.getColormodel() & 4) != 0;
        boolean bl2 = (pngChunkIHDR.getColormodel() & 1) != 0;
        boolean bl3 = pngChunkIHDR.getColormodel() == 0 || pngChunkIHDR.getColormodel() == 4;
        this.imgInfo = new ImageInfo(pngChunkIHDR.getCols(), pngChunkIHDR.getRows(), pngChunkIHDR.getBitspc(), bl, bl3, bl2);
        this.imgLine = new ImageLine(this.imgInfo);
        if (pngChunkIHDR.getInterlaced() != 0) {
            throw new PngjUnsupportedException("PNG interlaced not supported by this library");
        }
        if (pngChunkIHDR.getFilmeth() != 0 || pngChunkIHDR.getCompmeth() != 0) {
            throw new PngjInputException("compmethod o filtermethod unrecognized");
        }
        if (pngChunkIHDR.getColormodel() < 0 || pngChunkIHDR.getColormodel() > 6 || pngChunkIHDR.getColormodel() == 1 || pngChunkIHDR.getColormodel() == 5) {
            throw new PngjInputException("Invalid colormodel " + pngChunkIHDR.getColormodel());
        }
        if (pngChunkIHDR.getBitspc() != 1 && pngChunkIHDR.getBitspc() != 2 && pngChunkIHDR.getBitspc() != 4 && pngChunkIHDR.getBitspc() != 8 && pngChunkIHDR.getBitspc() != 16) {
            throw new PngjInputException("Invalid bit depth " + pngChunkIHDR.getBitspc());
        }
        this.rowbfilter = new byte[this.imgInfo.bytesPerRow + 1];
        this.rowb = new byte[this.imgInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
    }

    private PngChunk addChunkToList(ChunkRaw chunkRaw) {
        PngChunk pngChunk = PngChunk.factory(chunkRaw, this.imgInfo);
        if (!pngChunk.crit) {
            this.bytesChunksLoaded += chunkRaw.len;
        }
        if (this.bytesChunksLoaded > MAX_BYTES_CHUNKS_TO_LOAD) {
            throw new PngjInputException("Chunk exceeded available space (" + MAX_BYTES_CHUNKS_TO_LOAD + ") chunk: " + chunkRaw + " See PngReader.MAX_BYTES_CHUNKS_TO_LOAD\n");
        }
        this.chunksList.appendReadChunk(pngChunk, this.currentChunkGroup);
        return pngChunk;
    }

    public void readFirstChunks() {
        int n;
        if (!this.firstChunksNotYetRead()) {
            return;
        }
        int n2 = 0;
        boolean bl = false;
        byte[] byArray = new byte[4];
        this.currentChunkGroup = 1;
        while (!bl) {
            ChunkRaw chunkRaw;
            n2 = PngHelper.readInt4(this.is);
            this.offset += 4;
            if (n2 < 0) break;
            PngHelper.readBytes(this.is, byArray, 0, 4);
            this.offset += 4;
            if (Arrays.equals(byArray, ChunkHelper.b_IDAT)) {
                bl = true;
                this.currentChunkGroup = 4;
                chunkRaw = new ChunkRaw(0, byArray, false);
                this.addChunkToList(chunkRaw);
                break;
            }
            if (Arrays.equals(byArray, ChunkHelper.b_IEND)) {
                throw new PngjInputException("END chunk found before image data (IDAT) at offset=" + this.offset);
            }
            chunkRaw = new ChunkRaw(n2, byArray, true);
            String string = ChunkHelper.toString(byArray);
            boolean bl2 = ChunkHelper.shouldLoad(string, this.chunkLoadBehaviour);
            this.offset += chunkRaw.readChunkData(this.is);
            if (string.equals("PLTE")) {
                this.currentChunkGroup = 2;
            }
            if (bl2) {
                this.addChunkToList(chunkRaw);
            }
            if (!string.equals("PLTE")) continue;
            this.currentChunkGroup = 3;
        }
        int n3 = n = bl ? n2 : -1;
        if (n < 0) {
            throw new PngjInputException("first idat chunk not found!");
        }
        this.iIdatCstream = new PngIDatChunkInputStream(this.is, n, this.offset);
        this.idatIstream = new InflaterInputStream(this.iIdatCstream);
    }

    private void readLastChunks() {
        this.currentChunkGroup = 5;
        if (!this.iIdatCstream.isEnded()) {
            this.iIdatCstream.forceChunkEnd();
        }
        int n = this.iIdatCstream.getLenLastChunk();
        byte[] byArray = this.iIdatCstream.getIdLastChunk();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (!bl) {
            bl3 = false;
            if (!bl2) {
                n = PngHelper.readInt4(this.is);
                this.offset += 4;
                if (n < 0) {
                    throw new PngjInputException("bad len " + n);
                }
                PngHelper.readBytes(this.is, byArray, 0, 4);
                this.offset += 4;
            }
            bl2 = false;
            if (Arrays.equals(byArray, ChunkHelper.b_IDAT)) {
                bl3 = true;
            } else if (Arrays.equals(byArray, ChunkHelper.b_IEND)) {
                this.currentChunkGroup = 6;
                bl = true;
            }
            ChunkRaw chunkRaw = new ChunkRaw(n, byArray, true);
            String string = ChunkHelper.toString(byArray);
            boolean bl4 = ChunkHelper.shouldLoad(string, this.chunkLoadBehaviour);
            this.offset += chunkRaw.readChunkData(this.is);
            if (!bl4 || bl3) continue;
            this.addChunkToList(chunkRaw);
        }
        if (!bl) {
            throw new PngjInputException("end chunk not found - offset=" + this.offset);
        }
    }

    public ImageLine readRow(int n) {
        this.readRow(this.imgLine.scanline, n);
        this.imgLine.filterUsed = FilterType.getByVal(this.rowbfilter[0]);
        this.imgLine.setRown(n);
        return this.imgLine;
    }

    public int[] readRow(int[] nArray, int n) {
        if (n < 0 || n >= this.imgInfo.rows) {
            throw new PngjInputException("invalid line");
        }
        if (n != this.rowNum + 1) {
            throw new PngjInputException("invalid line (expected: " + (this.rowNum + 1));
        }
        if (n == 0 && this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        ++this.rowNum;
        if (nArray == null || nArray.length < this.imgInfo.samplesPerRowP) {
            nArray = new int[this.imgInfo.samplesPerRowP];
        }
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
        PngHelper.readBytes(this.idatIstream, this.rowbfilter, 0, this.rowbfilter.length);
        this.rowb[0] = 0;
        this.unfilterRow();
        this.rowb[0] = this.rowbfilter[0];
        this.convertRowFromBytes(nArray);
        return nArray;
    }

    public void end() {
        this.offset = (int)this.iIdatCstream.getOffset();
        try {
            this.idatIstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readLastChunks();
        try {
            this.is.close();
        }
        catch (Exception exception) {
            throw new PngjInputException("error closing input stream!", exception);
        }
    }

    private void convertRowFromBytes(int[] nArray) {
        if (this.imgInfo.bitDepth <= 8) {
            int n = 1;
            for (int i = 0; i < this.imgInfo.samplesPerRowP; ++i) {
                nArray[i] = this.rowb[n++] & 0xFF;
            }
        } else {
            int n = 1;
            for (int i = 0; i < this.imgInfo.samplesPerRowP; ++i) {
                nArray[i] = ((this.rowb[n++] & 0xFF) << 8) + (this.rowb[n++] & 0xFF);
            }
        }
    }

    private void unfilterRow() {
        byte by = this.rowbfilter[0];
        FilterType filterType = FilterType.getByVal(by);
        if (filterType == null) {
            throw new PngjInputException("Filter type " + by + " invalid");
        }
        switch (filterType) {
            case FILTER_NONE: {
                this.unfilterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.unfilterRowSub();
                break;
            }
            case FILTER_UP: {
                this.unfilterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.unfilterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.unfilterRowPaeth();
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + by + " not implemented");
            }
        }
    }

    private void unfilterRowNone() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowb[i] = this.rowbfilter[i];
        }
    }

    private void unfilterRowSub() {
        int n;
        for (n = 1; n <= this.imgInfo.bytesPixel; ++n) {
            this.rowb[n] = this.rowbfilter[n];
        }
        int n2 = 1;
        n = this.imgInfo.bytesPixel + 1;
        while (n <= this.imgInfo.bytesPerRow) {
            this.rowb[n] = (byte)(this.rowbfilter[n] + this.rowb[n2]);
            ++n;
            ++n2;
        }
    }

    private void unfilterRowUp() {
        for (int i = 1; i <= this.imgInfo.bytesPerRow; ++i) {
            this.rowb[i] = (byte)(this.rowbfilter[i] + this.rowbprev[i]);
        }
    }

    private void unfilterRowAverage() {
        int n = 1 - this.imgInfo.bytesPixel;
        int n2 = 1;
        while (n2 <= this.imgInfo.bytesPerRow) {
            int n3 = n > 0 ? this.rowb[n] & 0xFF : 0;
            this.rowb[n2] = (byte)(this.rowbfilter[n2] + (n3 + (this.rowbprev[n2] & 0xFF)) / 2);
            ++n2;
            ++n;
        }
    }

    private void unfilterRowPaeth() {
        int n = 1 - this.imgInfo.bytesPixel;
        int n2 = 1;
        while (n2 <= this.imgInfo.bytesPerRow) {
            int n3 = n > 0 ? this.rowb[n] & 0xFF : 0;
            int n4 = n > 0 ? this.rowbprev[n] & 0xFF : 0;
            this.rowb[n2] = (byte)(this.rowbfilter[n2] + FilterType.filterPaethPredictor(n3, this.rowbprev[n2] & 0xFF, n4));
            ++n2;
            ++n;
        }
    }

    public ChunkLoadBehaviour getChunkLoadBehaviour() {
        return this.chunkLoadBehaviour;
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.chunkLoadBehaviour = chunkLoadBehaviour;
    }

    private boolean firstChunksNotYetRead() {
        return this.currentChunkGroup < 1;
    }

    public ChunkList getChunksList() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.chunksList;
    }

    public PngMetadata getMetadata() {
        if (this.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.metadata;
    }

    public String toString() {
        return "filename=" + this.filename + " " + this.imgInfo.toString();
    }

    private static class FoundChunkInfo {
        public final String id;
        public final int len;
        public final int offset;
        public final boolean loaded;

        private FoundChunkInfo(String string, int n, int n2, boolean bl) {
            this.id = string;
            this.len = n;
            this.offset = n2;
            this.loaded = bl;
        }

        public String toString() {
            return "chunk " + this.id + " len=" + this.len + " offset=" + this.offset + (this.loaded ? " " : " X ");
        }
    }
}

