/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

public class GridFiller implements Runnable {
	/* A Runnable to check a single Grid for fillability and update the GUI
	 * indicator light. */
	public static int NOT_FOUND = -1;
	public static int SEARCHING = 0;
	public static int FOUND = 1;
	
	public Grid startNode;
	public StopFlag stopFlag;
	public MainInterface mainGUI;
	private Dictionary dict;
	
	public GridFiller(Grid g, MainInterface gui, Dictionary dict) {
		
		startNode = new Grid(g);
		stopFlag = new StopFlag();
		mainGUI = gui;
		this.dict = dict;
	}

	public GridFiller(Grid g, Dictionary dict) {
		this(g, null, dict);
	}

	@Override
	public void run() {
		//System.out.println("Autofilling in the background...");
		Grid result = startNode.autoFill(stopFlag,dict);
		if(result==null) {
			//System.out.println("none found");
			if (mainGUI != null) {
				synchronized(mainGUI) { // runs OK without the synchronized, but seems like a good idea
					mainGUI.updateFillIndicator(NOT_FOUND);
				}
			}
		}
		else {
			//System.out.println("found");
			if (mainGUI != null) {
				synchronized(mainGUI) {
					mainGUI.updateFillIndicator(FOUND);
				}
			}
		}
	}

}
