/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

import java.util.ArrayList;
import java.util.Comparator;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class FillOption {
	private String word;
	private int wordScore;
	private int fillScore;
	private boolean fillFound;
	
	public FillOption(String word, int wordScore) {
		this.word=word; this.wordScore=wordScore;
		fillScore=0; fillFound=false;
	}
	public String getWord() {return word;}
	public int getWordScore() {return wordScore;}
	public int getFillScore() {return fillScore;}
	public boolean isFillable() {return fillFound;}
	public void setFillable(boolean fillable) {fillFound = fillable;}
	public void setFillScore(int score) {fillScore = score;}
}

class FillOptionCompare implements Comparator<FillOption> {
	public static FillOptionCompare singleton;
	private FillOptionCompare() {}
	public static FillOptionCompare getInstance() {
		if (singleton == null) {singleton = new FillOptionCompare();}
		return singleton;
	}
	
	public int compare(FillOption a, FillOption b) {
		// 1 if b is "greater", -1 if "less", 0 if "equal"
		if (b.isFillable() && !a.isFillable()) return 1;
		if (a.isFillable() && !b.isFillable()) return -1;
		if (b.getWordScore()>a.getWordScore()) return 1;
		if (b.getWordScore()<a.getWordScore()) return -1;
		return 0;
	}
}

class FillTableModel implements TableModel {
	private static String[] COLUMN_NAMES = {"Word","Word score","Fill Score", "Fill found?"};
	private static Class<?>[] COLUMN_CLASSES = {String.class,Integer.class,Integer.class,Boolean.class};
	private ArrayList<FillOption> options;
	public FillTableModel(ArrayList<FillOption> options) {
		this.options = options;
	}
	public void setFillOptions(ArrayList<FillOption> options) {this.options=options;}

	@Override
	public void addTableModelListener(TableModelListener arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Class<?> getColumnClass(int k) {return COLUMN_CLASSES[k];}

	@Override
	public int getColumnCount() {return COLUMN_NAMES.length;}

	@Override
	public String getColumnName(int k) {return COLUMN_NAMES[k];}

	@Override
	public int getRowCount() {return options.size();}

	@Override
	public Object getValueAt(int row, int col) {
		FillOption opt = options.get(row);
		switch(col) {
		case 0: return opt.getWord();
		case 1: return opt.getWordScore();
		case 2: return opt.getFillScore();
		case 3: return opt.isFillable();
		}
		return null;
	}

	@Override
	public boolean isCellEditable(int arg0, int arg1) {return false;}

	@Override
	public void removeTableModelListener(TableModelListener arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setValueAt(Object arg0, int arg1, int arg2) {
		// TODO Auto-generated method stub
		
	}
	
}

public class FillView extends JScrollPane{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private FillTableModel tableModel;
	private JTable table;
	
	public FillView(ArrayList<FillOption> options) {
		tableModel = new FillTableModel(options);
		table = new JTable(tableModel);
		getViewport().add(table);
	}
	public void setFillOptions(ArrayList<FillOption> options) {
		tableModel.setFillOptions(options);
	}
	public void repaintTable() {
		table.revalidate();
		table.repaint();
	}
}
