/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;


public class CrosswordFile {
	private Grid g;
	private ClueList clues;
	public CrosswordFile(Grid grid, ClueList clues) {
		this.g = grid;
		this.clues = clues;
	}
	public CrosswordFile(File f) {
		try {
			loadIpuz(f);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	// also fields for meta-information and clues
	public void loadIpuz(File f) throws IOException {
		/* Load the grid into this object from file f. */
		FileReader reader = new FileReader(f);
		JSONTokener tokener = new JSONTokener(reader);
		JSONObject obj = new JSONObject(tokener);
		int dim = obj.getJSONObject("dimensions").getInt("width");
		//System.out.println("got width");
		g = new Grid(dim);
		for (int row=0; row<dim; ++row) {
			for (int col=0; col<dim; ++col) {
				String cell = obj.getJSONArray("solution")
						.getJSONArray(row)
						.getString(col);
				g.setChar(row, col, cell.charAt(0));
			}
		}
		clues = new ClueList(g); // will contain needed Clue objects; just need to set hints.
		JSONObject savedClues = obj.getJSONObject("clues");
		JSONArray acrossClues = savedClues.getJSONArray("Across");
		JSONArray downClues = savedClues.getJSONArray("Down");
		for (int k=0; k < acrossClues.length(); ++k) {
			JSONArray pair = acrossClues.getJSONArray(k);
			clues.setHint(pair.getInt(0), true, pair.getString(1));
		}
		for (int k=0; k < downClues.length(); ++k) {
			JSONArray pair = downClues.getJSONArray(k);
			clues.setHint(pair.getInt(0), false, pair.getString(1));
		}
		reader.close();
	}
	public void saveIpuz(File f) throws IOException {
		JSONObject obj = new JSONObject();
		obj.put("version", "http://ipuz.org/v2");
		obj.put("kind", new JSONArray().put("http://ipuz.org/crossword#1"));
		int dim = g.getDim();
		obj.put("dimensions", new JSONObject().put("width", dim).put("height",dim));
		JSONArray soln = new JSONArray();
		for (int row=0; row < dim; ++row) {
			JSONArray jsonRow = new JSONArray();
			for (int col=0; col<dim; ++col) {
				jsonRow.put(Character.toString(g.getChar(row,col)));
			}
			soln.put(jsonRow);
		}
		obj.put("solution", soln);
		JSONArray acrossClues = new JSONArray();
		JSONArray downClues = new JSONArray();
		for (int k= 0; k < clues.size(); ++k) {
			JSONArray entry = new JSONArray();
			entry.put(clues.getNumber(k)).put(clues.getHint(k));
			if (clues.isAcross(k)) {acrossClues.put(entry);}
			else {downClues.put(entry);}
		}
		obj.put("clues", new JSONObject().put("Across", acrossClues).put("Down", downClues));
		
		FileWriter writer = new FileWriter(f);
		writer.write(obj.toString());
		writer.close();
	}
	public Grid getGrid() {
		return g;
	}
	public ClueList getClueList() {
		return clues;
	}
}
