/* Copyright © 2021 Salvatore S. Elder Jr.
 * Under an MIT license
 * See LICENSE file for details
 */

import java.util.ArrayList;

public class OptionsChecker implements Runnable {
	/* A Runnable to check fill options and update their viability. */
	
	private Grid startNode;
	public StopFlag stopFlag;
	private Dictionary dict;
	private FillView fillView;
	private ArrayList<FillOption> options;
	private Coords slot;
	
	public OptionsChecker(Grid g, Coords slot, ArrayList<FillOption> options, Dictionary dict,
			FillView fillView) {
		startNode = new Grid(g); this.slot = slot;
		stopFlag = new StopFlag();
		this.options=options; this.dict = dict; this.fillView= fillView;
	}

	@Override
	public void run() {
		for (FillOption opt : options) {
			if (stopFlag.stopAutoFill) return;
			// insert it into the grid in the desired location
			Grid withWord = startNode.withWord(slot, opt.getWord());
			// autofill
			boolean wordFits = startNode.wordFits(slot, opt.getWord(), dict);
			Grid result = withWord.autoFill(stopFlag,dict);
			// if success, synchronize on options and update the fill score
			// then synchronize on fillView and revalidate/repaint
			synchronized(opt) {
				if (result != null && wordFits) {
					opt.setFillScore(result.getFillScore(dict));
					opt.setFillable(true);
				}
			}
			//synchronized(options) {
			//	options.sort(FillOptionCompare.getInstance());
			//}
			synchronized(fillView) {fillView.revalidate();fillView.repaint();}
		}
	}	

}
