import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class ClueTableModel implements TableModel {
	private static String[] COLUMN_NAMES = {"#","Direction","Answer","Hint"};
	private static Class<?>[] COLUMN_CLASSES = {Integer.class,String.class,String.class,String.class};
	
	private ClueList clues;
	public ClueTableModel(ClueList clues) {this.clues = clues;}
	@Override
	public void addTableModelListener(TableModelListener arg0) {
		// TODO Auto-generated method stub	
	}
	@Override
	public Class<?> getColumnClass(int k) {
		return COLUMN_CLASSES[k];
	}
	@Override
	public int getColumnCount() {
		return COLUMN_NAMES.length;
	}

	@Override
	public String getColumnName(int k) {
		return COLUMN_NAMES[k];
	}

	@Override
	public int getRowCount() {
		return clues.size();
	}

	@Override
	public Object getValueAt(int row, int col) {
		switch(col) {
		case 0:
			return clues.getNumber(row);
		case 1:
			return clues.getDirection(row);
		case 2:
			return clues.getAnswer(row);
		case 3:
			return clues.getHint(row);
		default:
			return null;
		}
	}

	@Override
	public boolean isCellEditable(int row, int col) {
		return (col == 3);
	}

	@Override
	public void removeTableModelListener(TableModelListener arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setValueAt(Object newHint, int row, int col) {
		clues.setHint(row, (String)newHint);		
	}
	
}

public class ClueView extends JScrollPane {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTable clueTable;

	public ClueView(ClueList clueList) {
		clueTable = new JTable(new ClueTableModel(clueList));
		this.getViewport().add(clueTable);
	}
}
