/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MainInterface
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static int SCALE = 6;
    public static int UNDO_LEVELS = 16;
    public static int DEFAULT_DIM = 15;
    public static String PROGRAM_NAME = "Jowcha";
    Grid grid;
    GridPanel gridgui;
    ClueList clueList;
    ClueView clueView;
    InfoPanel puzzleInfoPanel;
    ArrayList<FillOption> options;
    FillView fillView;
    Dictionary dict;
    Font guiFont;
    JLabel statistics;
    JLabel fillIndicator;
    JFileChooser fileChooser;
    FileNameExtensionFilter ipuzFilter;
    FileNameExtensionFilter pngFilter;
    FileNameExtensionFilter txtFilter;
    File currentFile;
    GridFiller backgroundFillChecker;
    OptionsChecker backgroundOptionsChecker;
    ImageIcon redLED;
    ImageIcon yellowLED;
    ImageIcon greenLED;
    private GridHistory gridHistory;

    public MainInterface() {
        this.updateTitle();
        this.setLocation(100, 100);
        this.setDefaultCloseOperation(3);
        this.guiFont = new Font("Arial", 0, 3 * SCALE);
        this.dict = new Dictionary("standard");
        this.dict.addWordList("scored_wordlist.txt");
        this.grid = new Grid(DEFAULT_DIM);
        this.gridgui = new GridPanel(this.grid, this);
        this.clueList = new ClueList(this.grid);
        this.clueView = new ClueView(this.clueList);
        this.puzzleInfoPanel = new InfoPanel();
        this.fileChooser = new JFileChooser();
        this.ipuzFilter = new FileNameExtensionFilter("ipuz", "ipuz");
        this.pngFilter = new FileNameExtensionFilter("png", "png");
        this.txtFilter = new FileNameExtensionFilter("txt", "txt");
        this.fileChooser.setFileFilter(this.ipuzFilter);
        this.currentFile = null;
        this.gridHistory = new GridHistory(this.grid);
        this.options = new ArrayList();
        this.fillView = new FillView(this.options);
        this.fillView.setFont(this.guiFont);
        JTabbedPane rightPane = new JTabbedPane();
        rightPane.addTab("Fill", this.fillView);
        rightPane.addTab("Clues", this.clueView);
        JSplitPane split = new JSplitPane(1, this.gridgui, rightPane);
        this.add((Component)split, "Center");
        int ctrlKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        KeyStroke ctrlZ = KeyStroke.getKeyStroke(90, ctrlKey);
        KeyStroke ctrlY = KeyStroke.getKeyStroke(89, ctrlKey);
        KeyStroke ctrlN = KeyStroke.getKeyStroke(78, ctrlKey);
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, ctrlKey);
        KeyStroke ctrlO = KeyStroke.getKeyStroke(79, ctrlKey);
        KeyStroke ctrlF = KeyStroke.getKeyStroke(70, ctrlKey);
        KeyStroke ctrlU = KeyStroke.getKeyStroke(85, ctrlKey);
        KeyStroke ctrlR = KeyStroke.getKeyStroke(82, ctrlKey);
        KeyStroke backtick = KeyStroke.getKeyStroke('`');
        JMenuBar menubar = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        menubar.add(filemenu);
        filemenu.setMnemonic('f');
        JMenu editmenu = new JMenu("Edit");
        menubar.add(editmenu);
        editmenu.setMnemonic('e');
        JMenu fillmenu = new JMenu("Fill");
        menubar.add(fillmenu);
        fillmenu.setMnemonic('i');
        JMenu helpmenu = new JMenu("Help");
        menubar.add(helpmenu);
        helpmenu.setMnemonic('h');
        JMenuItem newitem = new JMenuItem("New");
        filemenu.add(newitem);
        newitem.setAccelerator(ctrlN);
        JMenuItem openitem = new JMenuItem("Open");
        filemenu.add(openitem);
        openitem.setAccelerator(ctrlO);
        JMenuItem saveitem = new JMenuItem("Save");
        filemenu.add(saveitem);
        saveitem.setAccelerator(ctrlS);
        JMenuItem saveasitem = new JMenuItem("Save As...");
        filemenu.add(saveasitem);
        JMenu exportItem = new JMenu("Export");
        filemenu.add(exportItem);
        JMenuItem exportClues = new JMenuItem("Clues and answers (.txt)");
        exportItem.add(exportClues);
        JMenuItem exportCluesOnly = new JMenuItem("Clues only (.txt)");
        exportItem.add(exportCluesOnly);
        JMenuItem exportFilledGrid = new JMenuItem("Filled grid (.png)");
        exportItem.add(exportFilledGrid);
        JMenuItem exportEmptyGrid = new JMenuItem("Empty grid (.png)");
        exportItem.add(exportEmptyGrid);
        JMenuItem undoItem = new JMenuItem("Undo");
        undoItem.setAccelerator(ctrlZ);
        JMenuItem redoItem = new JMenuItem("Redo");
        redoItem.setAccelerator(ctrlY);
        JMenuItem resizeGridItem = new JMenuItem("Resize grid");
        resizeGridItem.setAccelerator(ctrlR);
        JMenuItem toggleBlackItem = new JMenuItem("Toggle black/white (backquote)");
        toggleBlackItem.setAccelerator(backtick);
        JMenuItem nextSlotItem = new JMenuItem("Suggest next slot");
        nextSlotItem.setAccelerator(ctrlU);
        JMenuItem autoFillItem = new JMenuItem("Auto Fill");
        autoFillItem.setAccelerator(ctrlF);
        editmenu.add(undoItem);
        undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainInterface.this.gridHistory.canUndo()) {
                    MainInterface.this.gridgui.grid = MainInterface.this.grid = MainInterface.this.gridHistory.undo();
                    MainInterface.this.gridgui.repaint();
                    MainInterface.this.updateStatistics();
                    MainInterface.this.updateClues();
                    MainInterface.this.checkFill();
                }
            }
        });
        editmenu.add(redoItem);
        redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainInterface.this.gridHistory.canRedo()) {
                    MainInterface.this.gridgui.grid = MainInterface.this.grid = MainInterface.this.gridHistory.redo();
                    MainInterface.this.gridgui.repaint();
                    MainInterface.this.updateStatistics();
                    MainInterface.this.updateClues();
                    MainInterface.this.checkFill();
                }
            }
        });
        editmenu.add(resizeGridItem);
        resizeGridItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String input = JOptionPane.showInputDialog("New side length (must be odd):");
                Integer newDim = Integer.parseInt(input);
                boolean success = false;
                if (newDim != null) {
                    success = MainInterface.this.grid.setDim(newDim);
                    MainInterface.this.gridgui.setCursor(0, 0);
                    MainInterface.this.gridgui.repaint();
                    MainInterface.this.gridHistory.push(MainInterface.this.grid);
                    MainInterface.this.updateStatistics();
                    MainInterface.this.checkFill();
                }
                if (!success) {
                    JOptionPane.showMessageDialog(MainInterface.this.gridgui, "Invalid dimension");
                }
            }
        });
        editmenu.add(toggleBlackItem);
        ActionListener toggleAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainInterface.this.gridgui.toggle();
            }
        };
        toggleBlackItem.addActionListener(toggleAction);
        fillmenu.add(nextSlotItem);
        nextSlotItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Coords next = MainInterface.this.grid.getNextToFill(MainInterface.this.dict);
                MainInterface.this.gridgui.setActiveWord(next);
            }
        });
        fillmenu.add(autoFillItem);
        autoFillItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Grid result = MainInterface.this.grid.autoFill(MainInterface.this.dict);
                if (result != null) {
                    MainInterface.this.gridgui.grid = MainInterface.this.grid = result;
                    MainInterface.this.updateClues();
                    MainInterface.this.gridHistory.push(MainInterface.this.grid);
                    MainInterface.this.gridgui.repaint();
                }
            }
        });
        class IPuzFileListener
        extends 1FileListener {
            boolean save;
            boolean saveas;

            IPuzFileListener(boolean save, boolean saveas, JMenuBar jMenuBar) {
                abstract class FileListener
                implements ActionListener {
                    FileNameExtensionFilter filter;
                    private final /* synthetic */ JMenuBar val$menubar;

                    public FileListener(FileNameExtensionFilter filter, JMenuBar jMenuBar) {
                        this.val$menubar = jMenuBar;
                        this.filter = filter;
                    }

                    public File getSaveFile() {
                        MainInterface.this.fileChooser.setFileFilter(this.filter);
                        if (MainInterface.this.fileChooser.showSaveDialog(this.val$menubar) == 0) {
                            File selectedFile = MainInterface.this.fileChooser.getSelectedFile();
                            if (MainInterface.this.fileChooser.getFileFilter() == this.filter && !this.filter.accept(selectedFile)) {
                                String newName = String.valueOf(selectedFile.getAbsolutePath()) + "." + this.filter.getExtensions()[0];
                                selectedFile = new File(newName);
                            }
                            return selectedFile;
                        }
                        return null;
                    }

                    public File getOpenFile() {
                        MainInterface.this.fileChooser.setFileFilter(this.filter);
                        if (MainInterface.this.fileChooser.showOpenDialog(this.val$menubar) == 0) {
                            return MainInterface.this.fileChooser.getSelectedFile();
                        }
                        return null;
                    }
                }
                super(MainInterface.this.ipuzFilter, jMenuBar);
                this.save = save;
                this.saveas = saveas;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (this.saveas || this.save && MainInterface.this.currentFile == null) {
                        File selectedFile = this.getSaveFile();
                        if (selectedFile != null) {
                            CrosswordFile xf = new CrosswordFile(MainInterface.this.grid, MainInterface.this.clueList);
                            xf.saveIpuz(selectedFile);
                            MainInterface.this.currentFile = selectedFile;
                            MainInterface.this.updateTitle();
                        }
                    } else if (this.save && MainInterface.this.currentFile != null) {
                        CrosswordFile xf = new CrosswordFile(MainInterface.this.grid, MainInterface.this.clueList);
                        xf.saveIpuz(MainInterface.this.currentFile);
                        MainInterface.this.updateTitle();
                    } else {
                        File selectedFile = this.getOpenFile();
                        if (selectedFile != null) {
                            MainInterface.this.currentFile = selectedFile;
                            CrosswordFile xf = new CrosswordFile(MainInterface.this.currentFile);
                            MainInterface.this.grid = xf.getGrid();
                            MainInterface.this.clueList.setAll(xf.getClueList());
                            MainInterface.this.gridgui.setGrid(MainInterface.this.grid);
                            MainInterface.this.updateTitle();
                            MainInterface.this.gridgui.repaint();
                            MainInterface.this.updateClues();
                            MainInterface.this.updateStatistics();
                            MainInterface.this.checkFill();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        openitem.addActionListener(new IPuzFileListener(false, false, menubar));
        saveitem.addActionListener(new IPuzFileListener(true, false, menubar));
        saveasitem.addActionListener(new IPuzFileListener(true, true, menubar));
        newitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainInterface.this.grid = new Grid(DEFAULT_DIM);
                MainInterface.this.gridgui.setGrid(MainInterface.this.grid);
                MainInterface.this.gridgui.repaint();
                MainInterface.this.updateStatistics();
                MainInterface.this.updateClues();
                MainInterface.this.clueList.clearHints();
                MainInterface.this.checkFill();
                MainInterface.this.gridHistory.push(MainInterface.this.grid);
                MainInterface.this.currentFile = null;
                MainInterface.this.updateTitle();
            }
        });
        class PngFileListener
        extends 1FileListener {
            private boolean withFill;

            public PngFileListener(boolean withFill, JMenuBar jMenuBar) {
                super(MainInterface.this.pngFilter, jMenuBar);
                this.withFill = withFill;
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File f = this.getSaveFile();
                try {
                    if (f != null) {
                        MainInterface.this.gridgui.saveImage(f, this.withFill);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        exportFilledGrid.addActionListener(new PngFileListener(true, menubar));
        exportEmptyGrid.addActionListener(new PngFileListener(false, menubar));
        class TxtFileListener
        extends 1FileListener {
            boolean withAnswers;

            public TxtFileListener(boolean withAnswers, JMenuBar jMenuBar) {
                super(MainInterface.this.txtFilter, jMenuBar);
                this.withAnswers = withAnswers;
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File f = this.getSaveFile();
                try {
                    if (f != null) {
                        MainInterface.this.clueList.saveClues(f, this.withAnswers);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        exportClues.addActionListener(new TxtFileListener(true, menubar));
        exportCluesOnly.addActionListener(new TxtFileListener(false, menubar));
        this.setJMenuBar(menubar);
        this.statistics = new JLabel("");
        this.redLED = this.makeIcon("redLED.png", "Red LED");
        this.yellowLED = this.makeIcon("yellowLED.png", "Yellow LED");
        this.greenLED = this.makeIcon("greenLED.png", "Green LED");
        this.fillIndicator = new JLabel("", this.yellowLED, 2);
        this.updateStatistics();
        this.checkFill();
        this.statistics.setFont(this.guiFont);
        this.fillIndicator.setFont(this.guiFont);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.statistics, "After");
        bottomPanel.add((Component)this.fillIndicator, "Before");
        this.add((Component)bottomPanel, "Last");
        this.pack();
        this.setVisible(true);
    }

    private void updateTitle() {
        String filename = "Untitled";
        if (this.currentFile != null) {
            filename = this.currentFile.getName();
        }
        this.setTitle(String.format("%s - %s", filename, PROGRAM_NAME));
    }

    public void saveState() {
        this.gridHistory.push(this.grid);
    }

    private ImageIcon makeIcon(String filename, String description) {
        URL url = this.getClass().getResource(filename);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url, description);
    }

    public void updatePoss(String query) {
        this.options = this.dict.lookup(query);
        this.fillView.setFillOptions(this.options);
        this.fillView.revalidate();
        this.fillView.repaint();
        this.fillView.repaintTable();
        this.checkOptions();
    }

    public void updateStatistics() {
        int numBlocks = this.grid.countBlocks();
        int numWords = this.grid.countWords();
        this.statistics.setText(String.format("<html>Words: %d/78<br/>Blocks: %d/42</html>", numWords, numBlocks));
    }

    public void updateFillIndicator(int possibility) {
        String text = "Fill not found";
        ImageIcon icon = this.redLED;
        if (possibility == GridFiller.FOUND) {
            text = "Fill possible";
            icon = this.greenLED;
        } else if (possibility == GridFiller.SEARCHING) {
            text = "Searching for fill...";
            icon = this.yellowLED;
        }
        this.fillIndicator.setText(text);
        this.fillIndicator.setIcon(icon);
    }

    public void checkFill() {
        this.updateFillIndicator(GridFiller.SEARCHING);
        if (this.backgroundFillChecker != null) {
            this.backgroundFillChecker.stopFlag.stopAutoFill = true;
        }
        this.backgroundFillChecker = new GridFiller(this.grid, this, this.dict);
        Thread bgThread = new Thread(this.backgroundFillChecker);
        bgThread.start();
    }

    public void checkOptions() {
        if (this.backgroundOptionsChecker != null) {
            this.backgroundOptionsChecker.stopFlag.stopAutoFill = true;
        }
        Coords slot = this.gridgui.getSelectedSlot();
        this.backgroundOptionsChecker = new OptionsChecker(this.grid, slot, this.options, this.dict, this.fillView);
        Thread bgOptThread = new Thread(this.backgroundOptionsChecker);
        bgOptThread.start();
    }

    public void updateClues() {
        this.clueList.update(this.grid);
        this.clueView.revalidate();
        this.clueView.repaint();
    }

    public static void main(String[] args) {
        new MainInterface();
    }

    private class GridHistory {
        Grid[] history = new Grid[UNDO_LEVELS];
        int oldestIndex;
        int currentIndex;

        public GridHistory(Grid initialGrid) {
            this.history[0] = new Grid(initialGrid);
            this.oldestIndex = 0;
            this.currentIndex = 0;
        }

        public void push(Grid g) {
            ++this.currentIndex;
            this.history[this.currentIndex % MainInterface.UNDO_LEVELS] = new Grid(g);
            if (this.currentIndex % UNDO_LEVELS == this.oldestIndex % UNDO_LEVELS) {
                this.oldestIndex = (this.oldestIndex + 1) % UNDO_LEVELS;
            }
            int k = this.currentIndex + 1;
            while (k % UNDO_LEVELS != this.oldestIndex % UNDO_LEVELS) {
                this.history[k % MainInterface.UNDO_LEVELS] = null;
                ++k;
            }
        }

        public boolean canUndo() {
            return this.currentIndex % UNDO_LEVELS != this.oldestIndex % UNDO_LEVELS;
        }

        public boolean canRedo() {
            return (this.currentIndex + 1) % UNDO_LEVELS != this.oldestIndex % UNDO_LEVELS && this.history[(this.currentIndex + 1) % UNDO_LEVELS] != null;
        }

        public Grid undo() {
            if (!this.canUndo()) {
                return null;
            }
            this.currentIndex = (this.currentIndex - 1 + UNDO_LEVELS) % UNDO_LEVELS;
            return new Grid(this.history[this.currentIndex]);
        }

        public Grid redo() {
            if (!this.canRedo()) {
                return null;
            }
            return new Grid(this.history[++this.currentIndex % UNDO_LEVELS]);
        }
    }
}

