/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class GridPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    MainInterface gui;
    Grid grid;
    static Font capsFont = new Font("Arial", 0, 4 * MainInterface.SCALE);
    static Font clueNumFont = new Font("Arial", 0, 2 * MainInterface.SCALE);
    static Color cursorLight = new Color(255, 255, 200);
    static Color cursorMed = new Color(255, 200, 120);
    static Color cursorDark = new Color(112, 91, 44);
    int sqsize = 6;
    static int XPAD = MainInterface.SCALE * 2;
    static int YPAD = -MainInterface.SCALE;
    String message = "";
    int row = 0;
    int col = 0;
    boolean horiz = true;

    public GridPanel(Grid grid, MainInterface gui) {
        this.grid = grid;
        this.gui = gui;
        this.addKeyListener(new GridKeys(this));
        this.addMouseListener(new GridMouse(this));
    }

    public void setGrid(Grid g) {
        this.grid = g;
    }

    public void setCursor(int r, int c) {
        this.row = r;
        this.col = c;
    }

    public void enterChar(char ch) {
        if (this.grid.enterChar(this.row, this.col, ch)) {
            this.whiteMove(this.horiz ? 1 : 0, this.horiz ? 0 : 1);
            this.gui.checkFill();
            this.gui.updateClues();
            this.gui.saveState();
        }
    }

    public void setActiveWord(Coords c) {
        this.row = c.r;
        this.col = c.c;
        this.horiz = c.dirhoriz;
        this.repaint();
    }

    public Coords getSelectedSlot() {
        return new Coords(this.row, this.col, this.horiz);
    }

    public void backspace() {
        if (this.grid.enterChar(this.row, this.col, ' ')) {
            this.whiteMove(this.horiz ? -1 : 0, this.horiz ? 0 : -1);
            this.gui.checkFill();
            this.gui.updateClues();
            this.gui.saveState();
        }
    }

    public void delete() {
        if (this.grid.enterChar(this.row, this.col, ' ')) {
            this.whiteMove(this.horiz ? 1 : 0, this.horiz ? 0 : 1);
            this.gui.checkFill();
            this.gui.updateClues();
            this.gui.saveState();
        }
    }

    public void whiteMove(int dx, int dy) {
        int newr = this.row + dy;
        int newc = this.col + dx;
        if (!this.grid.onGrid(newr, newc) || this.grid.isBlack(newr, newc)) {
            this.repaint();
            return;
        }
        this.row = newr;
        this.col = newc;
        this.repaint();
    }

    @Override
    public void move(int dx, int dy) {
        if (!this.grid.isBlack(this.row, this.col) && (dy != 0 && this.horiz || dx != 0 && !this.horiz)) {
            this.horiz = !this.horiz;
            this.repaint();
            return;
        }
        this.col += dx;
        this.row += dy;
        this.horiz = dy == 0;
        this.row = this.grid.clipToDim(this.row);
        this.col = this.grid.clipToDim(this.col);
        this.repaint();
    }

    public void toggle() {
        this.grid.toggle(this.row, this.col);
        this.repaint();
        this.gui.updateStatistics();
        this.gui.checkFill();
        this.gui.updateClues();
        this.gui.saveState();
    }

    public String currentWord() {
        return this.grid.getWord(this.row, this.col, this.horiz);
    }

    @Override
    public Dimension getPreferredSize() {
        int dim = this.grid.getDim();
        return new Dimension(dim * this.sqsize * MainInterface.SCALE, dim * this.sqsize * MainInterface.SCALE);
    }

    public int getSquarePx() {
        return MainInterface.SCALE * this.sqsize;
    }

    public void saveImage(File f, boolean filled) throws IOException {
        Dimension dim = this.getPreferredSize();
        BufferedImage im = new BufferedImage(dim.width, dim.height, 1);
        this.paintComponent(im.getGraphics(), false, filled, false);
        ImageIO.write((RenderedImage)im, "png", f);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponent(g, true, true, true);
    }

    public void paintComponent(Graphics g, boolean withHighlight, boolean withFill, boolean refreshGUI) {
        super.paintComponent(g);
        if (refreshGUI) {
            this.gui.updatePoss(this.grid.getWord(this.row, this.col, this.horiz));
        }
        int sqpx = MainInterface.SCALE * this.sqsize;
        g.setColor(Color.WHITE);
        int dim = this.grid.getDim();
        g.fillRect(0, 0, this.sqsize * dim * MainInterface.SCALE, this.sqsize * dim * MainInterface.SCALE);
        if (withHighlight) {
            g.setColor(cursorLight);
            ArrayList<Coords> wordsquares = this.grid.getWordSquares(this.row, this.col, this.horiz);
            for (Coords c : wordsquares) {
                g.fillRect(c.c * sqpx, c.r * sqpx, sqpx, sqpx);
            }
            g.setColor(this.grid.isBlack(this.row, this.col) ? cursorDark : cursorMed);
            g.fillRect(this.col * sqpx, this.row * sqpx, sqpx, sqpx);
        }
        g.setColor(Color.BLACK);
        int j = 0;
        while (j < dim) {
            int k = 0;
            while (k < dim) {
                g.drawRect(k * sqpx, j * sqpx, sqpx, sqpx);
                boolean isBlack = this.grid.isBlack(j, k);
                if (!isBlack) {
                    if (withFill) {
                        g.setFont(capsFont);
                        g.drawString(String.valueOf(Character.toUpperCase(this.grid.getChar(j, k))), k * sqpx + XPAD, (j + 1) * sqpx + YPAD);
                    }
                    g.setFont(clueNumFont);
                    Integer clueNum = this.grid.clueNumbers[j][k];
                    if (clueNum != null) {
                        g.drawString(this.grid.clueNumbers[j][k].toString(), k * sqpx, j * sqpx + clueNumFont.getSize());
                    }
                }
                if (isBlack && (j != this.row || k != this.col || !withHighlight)) {
                    g.fillRect(k * sqpx, j * sqpx, sqpx, sqpx);
                }
                ++k;
            }
            ++j;
        }
    }
}

