/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ClueList {
    private Grid grid;
    private ArrayList<Clue> clues;
    private HashMap<Coords, Clue> coordsToClue;

    public ClueList(Grid g) {
        this.grid = g;
        this.clues = new ArrayList();
        this.coordsToClue = new HashMap();
        int row = 0;
        while (row < g.dim) {
            int col = 0;
            while (col < g.dim) {
                Clue thisClue;
                Coords coords;
                if (this.grid.hasAcrossClue(row, col)) {
                    coords = new Coords(row, col, true);
                    thisClue = new Clue(coords, g.clueNumbers[row][col], this.grid.getWord(row, col, true), "");
                    this.clues.add(thisClue);
                    this.coordsToClue.put(coords, thisClue);
                }
                if (this.grid.hasDownClue(row, col)) {
                    coords = new Coords(row, col, false);
                    thisClue = new Clue(coords, g.clueNumbers[row][col], this.grid.getWord(row, col, false), "");
                    this.clues.add(thisClue);
                    this.coordsToClue.put(coords, thisClue);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setHint(int clueNumber, boolean isAcross, String hint) {
        for (Clue clue : this.clues) {
            if (clueNumber != clue.clueNumber || clue.coords.dirhoriz != isAcross) continue;
            clue.hint = hint;
            return;
        }
    }

    public void setAll(ClueList other) {
        this.grid = other.grid;
        this.clues = other.clues;
        this.coordsToClue = other.coordsToClue;
    }

    public int size() {
        return this.clues.size();
    }

    public int getNumber(int k) {
        return this.clues.get((int)k).clueNumber;
    }

    public String getDirection(int k) {
        return this.clues.get((int)k).coords.dirhoriz ? "Across" : "Down";
    }

    public boolean isAcross(int k) {
        return this.clues.get((int)k).coords.dirhoriz;
    }

    public String getAnswer(int k) {
        return this.clues.get((int)k).answer;
    }

    public String getHint(int k) {
        return this.clues.get((int)k).hint;
    }

    public void setHint(int k, String newHint) {
        Clue clue = this.clues.get(k);
        if (clue != null) {
            clue.hint = newHint;
        }
    }

    private void merge(ClueList newClueList) {
        for (Clue clue : newClueList.clues) {
            String oldHint;
            boolean inOldList = this.coordsToClue.containsKey(clue.coords);
            if (!inOldList) continue;
            clue.hint = oldHint = this.coordsToClue.get((Object)clue.coords).hint;
        }
    }

    public void update(Grid g) {
        ClueList updatedList = new ClueList(g);
        this.merge(updatedList);
        this.grid = g;
        this.clues = updatedList.clues;
        this.coordsToClue = updatedList.coordsToClue;
    }

    public void clearHints() {
        for (Clue c : this.clues) {
            c.hint = "";
        }
    }

    public ArrayList<Clue> getCluesByDirection(boolean across) {
        ArrayList<Clue> result = new ArrayList<Clue>();
        for (Clue c : this.clues) {
            if (c.coords.dirhoriz != across) continue;
            result.add(c);
        }
        return result;
    }

    public void saveClues(File f, boolean withAnswers) throws IOException {
        int CLUE_WIDTH = 80;
        FileWriter writer = new FileWriter(f);
        boolean dir = true;
        do {
            String type = "ACROSS";
            if (!dir) {
                type = "DOWN";
            }
            writer.write(String.valueOf(type) + "\n");
            for (Clue c : this.getCluesByDirection(dir)) {
                if (withAnswers) {
                    writer.write(String.format("%-3d%-" + Integer.toString(CLUE_WIDTH) + "s\t%s\n", c.clueNumber, c.hint, c.answer.toUpperCase()));
                    continue;
                }
                writer.write(String.format("%-3d%s\n", c.clueNumber, c.hint));
            }
            if (!dir) continue;
            writer.write("\n");
        } while (!(dir = !dir));
        writer.close();
    }
}

