/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;

public class Grid {
    public static int MAX_WORDS = 100;
    public static char BLOCK_CHAR = (char)35;
    public static char BLANK_CHAR = (char)32;
    public static int DOWN = 0;
    public static int ACROSS = 1;
    public static int BOTH = 2;
    char[][] squares;
    Integer[][] clueNumbers;
    ClueDirection[][] clueDirections;
    int dim;
    private Coords nextToFill = null;
    private PriorityQueue<WordScore> candidatesRanked = null;
    public HashMap<Coords, Grid> backJumpTo;

    public Grid(int d) {
        this.dim = d;
        this.squares = new char[this.dim][this.dim];
        this.clueNumbers = new Integer[this.dim][this.dim];
        this.clueDirections = new ClueDirection[this.dim][this.dim];
        this.backJumpTo = new HashMap();
        int j = 0;
        while (j < this.dim) {
            int k = 0;
            while (k < this.dim) {
                this.squares[j][k] = 32;
                ++k;
            }
            ++j;
        }
        this.numberSquares();
    }

    public Grid(Grid g) {
        this(g.dim);
        int row = 0;
        while (row < g.dim) {
            int col = 0;
            while (col < g.dim) {
                this.squares[row][col] = g.squares[row][col];
                ++col;
            }
            ++row;
        }
        this.numberSquares();
    }

    public void save(File f) throws IOException {
        FileWriter writer = new FileWriter(f);
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                writer.write(this.squares[row][col]);
                ++col;
            }
            ++row;
        }
        writer.close();
    }

    public void load(File f) throws IOException {
        FileReader reader = new FileReader(f);
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                this.squares[row][col] = (char)reader.read();
                ++col;
            }
            ++row;
        }
        reader.close();
        this.numberSquares();
    }

    public boolean onGrid(int row, int col) {
        return row < this.dim && col < this.dim && row >= 0 && col >= 0;
    }

    public boolean enterChar(int row, int col, char ch) {
        if ((ch = Character.toLowerCase(ch)) != ' ' && !Character.isAlphabetic(ch)) {
            return false;
        }
        if (this.isBlack(row, col)) {
            return false;
        }
        this.squares[row][col] = ch;
        return true;
    }

    public char getChar(int row, int col) {
        return this.squares[row][col];
    }

    public char getChar(Coords c) {
        return this.getChar(c.r, c.c);
    }

    public boolean isBlack(int row, int col) {
        return this.squares[row][col] == BLOCK_CHAR;
    }

    public int countBlocks() {
        int count = 0;
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                count += this.isBlack(row, col) ? 1 : 0;
                ++col;
            }
            ++row;
        }
        return count;
    }

    public int countWords(int index, boolean searchWithinRow) {
        boolean prevBlack = true;
        int count = 0;
        int k = 0;
        while (k < this.dim) {
            boolean thisBlack = this.isBlack(k, index);
            if (searchWithinRow) {
                thisBlack = this.isBlack(index, k);
            }
            if (prevBlack && !thisBlack) {
                ++count;
            }
            prevBlack = thisBlack;
            ++k;
        }
        return count;
    }

    public int countWords() {
        int count = 0;
        int row = 0;
        while (row < this.dim) {
            count += this.countWords(row, true);
            ++row;
        }
        int col = 0;
        while (col < this.dim) {
            count += this.countWords(col, false);
            ++col;
        }
        return count;
    }

    private void numberSquares() {
        int nextNum = 1;
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                boolean white = !this.isBlack(row, col);
                boolean startsH = white && (col == 0 || this.isBlack(row, col - 1));
                boolean startsV = white && (row == 0 || this.isBlack(row - 1, col));
                this.clueNumbers[row][col] = startsH || startsV ? Integer.valueOf(nextNum++) : null;
                ClueDirection cd = ClueDirection.NEITHER;
                if (startsH && startsV) {
                    cd = ClueDirection.BOTH;
                } else if (startsH) {
                    cd = ClueDirection.ACROSS;
                } else if (startsV) {
                    cd = ClueDirection.DOWN;
                }
                this.clueDirections[row][col] = cd;
                ++col;
            }
            ++row;
        }
    }

    public boolean hasAcrossClue(int row, int col) {
        ClueDirection cd = this.clueDirections[row][col];
        return cd == ClueDirection.ACROSS || cd == ClueDirection.BOTH;
    }

    public boolean hasDownClue(int row, int col) {
        ClueDirection cd = this.clueDirections[row][col];
        return cd == ClueDirection.DOWN || cd == ClueDirection.BOTH;
    }

    public boolean isEmpty(int row, int col) {
        return this.squares[row][col] == ' ';
    }

    public int clipToDim(int coord) {
        if (coord >= this.dim) {
            return this.dim - 1;
        }
        if (coord < 0) {
            return 0;
        }
        return coord;
    }

    public int getDim() {
        return this.dim;
    }

    public boolean setDim(int d) {
        if (d % 2 == 0 || d < 1 || d > 101) {
            return false;
        }
        char[][] newSquares = new char[d][d];
        int pad = (d - this.dim) / 2;
        int row = 0;
        while (row < d) {
            int col = 0;
            while (col < d) {
                int oldRow = row - pad;
                int oldCol = col - pad;
                newSquares[row][col] = oldRow >= 0 && oldRow < this.dim && oldCol >= 0 && oldCol < this.dim ? this.squares[oldRow][oldCol] : 32;
                ++col;
            }
            ++row;
        }
        this.dim = d;
        this.squares = newSquares;
        this.clueNumbers = new Integer[this.dim][this.dim];
        this.clueDirections = new ClueDirection[this.dim][this.dim];
        this.numberSquares();
        return true;
    }

    public boolean toggle(int row, int col) {
        int dest;
        if (!this.onGrid(row, col)) {
            return false;
        }
        int n = dest = this.isBlack(row, col) ? 32 : (int)BLOCK_CHAR;
        this.squares[this.dim - row - 1][this.dim - col - 1] = n;
        this.squares[row][col] = n;
        this.numberSquares();
        return true;
    }

    public void setChar(int row, int col, char letter) {
        this.squares[row][col] = letter;
        if (letter == BLOCK_CHAR) {
            this.numberSquares();
        }
    }

    public void setChar(Coords c, char letter) {
        this.setChar(c.r, c.c, letter);
    }

    public boolean wordFits(Coords loc, String word, Dictionary dict) {
        double lookahead = this.getLookaheadScore(this.getWordSquares(loc), word, dict);
        return lookahead > 0.1;
    }

    public Grid withWord(Coords loc, String word) {
        Grid result = new Grid(this);
        ArrayList<Coords> squares = this.getWordSquares(loc);
        int k = 0;
        while (k < word.length() && k < squares.size()) {
            result.setChar(squares.get(k), word.charAt(k));
            ++k;
        }
        return result;
    }

    public ArrayList<Coords> getWordSquares(int row, int col, boolean dirhoriz) {
        ArrayList<Coords> res = new ArrayList<Coords>();
        if (dirhoriz) {
            int c = col;
            while (c < this.dim && !this.isBlack(row, c)) {
                res.add(new Coords(row, c, true));
                ++c;
            }
            c = col - 1;
            while (c >= 0 && !this.isBlack(row, c)) {
                res.add(0, new Coords(row, c, true));
                --c;
            }
        } else {
            int r = row;
            while (r < this.dim && !this.isBlack(r, col)) {
                res.add(new Coords(r, col, false));
                ++r;
            }
            r = row - 1;
            while (r >= 0 && !this.isBlack(r, col)) {
                res.add(0, new Coords(r, col, false));
                --r;
            }
        }
        return res;
    }

    public ArrayList<Coords> getWordSquares(Coords c) {
        return this.getWordSquares(c.r, c.c, c.dirhoriz);
    }

    public ArrayList<Coords> getSlots() {
        ArrayList<Coords> res = new ArrayList<Coords>();
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                if (!this.isBlack(row, col) && (col == 0 || this.isBlack(row, col - 1))) {
                    res.add(new Coords(row, col, true));
                }
                if (!this.isBlack(row, col) && (row == 0 || this.isBlack(row - 1, col))) {
                    res.add(new Coords(row, col, false));
                }
                ++col;
            }
            ++row;
        }
        return res;
    }

    public ArrayList<String> getWords() {
        ArrayList<String> res = new ArrayList<String>();
        for (Coords c : this.getSlots()) {
            res.add(this.getWord(c));
        }
        return res;
    }

    public boolean isFilled(Coords firstSquare) {
        for (Coords letter : this.getWordSquares(firstSquare)) {
            if (!this.isEmpty(letter.r, letter.c)) continue;
            return false;
        }
        return true;
    }

    public Coords getNextToFill(Dictionary dict) {
        ArrayList<Coords> slots = this.getSlots();
        int fewestOptions = Integer.MAX_VALUE;
        Coords result = new Coords(0, 0, true);
        for (Coords c : slots) {
            int numOptions = dict.countWords(this.getWord(c));
            if (numOptions >= fewestOptions || this.isFilled(c)) continue;
            fewestOptions = numOptions;
            result = c;
        }
        return result;
    }

    public Grid autoFill(Dictionary dict) {
        return this.autoFill(null, dict);
    }

    public Grid autoFill(StopFlag flag, Dictionary dict) {
        this.initializeAutoFill(flag, dict);
        Grid result = this.continueAutoFill(flag, dict);
        if (result != null) {
            result.numberSquares();
        }
        return result;
    }

    public boolean isFilled() {
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                if (this.isEmpty(row, col)) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    private void initializeAutoFill(StopFlag flag, Dictionary dict) {
        this.nextToFill = this.getNextToFill(dict);
        ArrayList<Coords> squaresList = this.getWordSquares(this.nextToFill);
        ArrayList<FillOption> options = dict.lookup(this.getWord(this.nextToFill));
        this.candidatesRanked = new PriorityQueue<WordScore>(new WordCompare());
        int k = 0;
        while (k < MAX_WORDS && k < options.size()) {
            String candidate = options.get(k).getWord();
            double lookaheadScore = this.getLookaheadScore(squaresList, candidate, dict);
            this.candidatesRanked.add(new WordScore(candidate, lookaheadScore));
            ++k;
        }
    }

    private Grid continueAutoFill(StopFlag flag, Dictionary dict) {
        if (flag != null && flag.stopAutoFill) {
            System.out.println("autofill stopped.");
            return null;
        }
        if (this.candidatesRanked == null) {
            this.initializeAutoFill(flag, dict);
        }
        if (this.isFilled()) {
            return this;
        }
        if (this.candidatesRanked.isEmpty() || this.candidatesRanked.peek().score < 0.9) {
            Grid backTarget = this.backJumpTo.get(this.nextToFill);
            if (backTarget == null) {
                return null;
            }
            return backTarget.continueAutoFill(flag, dict);
        }
        String chosenWord = this.candidatesRanked.poll().word;
        Grid childNode = new Grid(this.dim);
        int row = 0;
        while (row < this.dim) {
            int col = 0;
            while (col < this.dim) {
                childNode.squares[row][col] = this.squares[row][col];
                ++col;
            }
            ++row;
        }
        ArrayList<Coords> chosenSquares = this.getWordSquares(this.nextToFill);
        int k = 0;
        while (k < chosenWord.length()) {
            Coords chosenSquare = chosenSquares.get(k);
            childNode.setChar(chosenSquare, chosenWord.charAt(k));
            for (Coords xSquare : this.getWordSquares(chosenSquare.r, chosenSquare.c, !chosenSquare.dirhoriz)) {
                childNode.backJumpTo.put(xSquare, this);
                for (Coords xxSquare : this.getWordSquares(xSquare.r, xSquare.c, !xSquare.dirhoriz)) {
                    childNode.backJumpTo.put(xxSquare, this);
                }
            }
            ++k;
        }
        return childNode.autoFill(flag, dict);
    }

    public double getLookaheadScore(ArrayList<Coords> squares, String candidate, Dictionary dict) {
        double score = 1.0;
        int k = 0;
        while (k < squares.size()) {
            Coords square = squares.get(k);
            String query = this.getWord(square.r, square.c, !square.dirhoriz, candidate.charAt(k));
            if (query.indexOf(BLANK_CHAR) != -1 || this.getChar(square) == BLANK_CHAR) {
                score *= (double)dict.countWords(query);
            }
            ++k;
        }
        return score;
    }

    public String getWord(int row, int col, boolean dirhoriz) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Coords> wordsquares = this.getWordSquares(row, col, dirhoriz);
        for (Coords c : wordsquares) {
            sb.append(this.squares[c.r][c.c]);
        }
        return sb.toString();
    }

    public String getWord(Coords c) {
        return this.getWord(c.r, c.c, c.dirhoriz);
    }

    public String getWord(int row, int col, boolean dirhoriz, char override) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Coords> wordsquares = this.getWordSquares(row, col, dirhoriz);
        for (Coords c : wordsquares) {
            sb.append(c.r == row && c.c == col ? override : this.squares[c.r][c.c]);
        }
        return sb.toString();
    }

    public int getFillScore(Dictionary dict) {
        double score = 0.0;
        ArrayList<String> words = this.getWords();
        for (String w : words) {
            score += (double)dict.getWordScore(w);
        }
        return Double.valueOf(score).intValue();
    }

    public static enum ClueDirection {
        NEITHER,
        BOTH,
        ACROSS,
        DOWN;

    }
}

