/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class Dictionary {
    public static int DEFAULT_SCORE = 1;
    public static String SCORE_DELIMITER = ";";
    Node root = new Node(null, '\u0000', -1, false, 0);
    String description;
    HashMap<String, Integer> countWordsMemoTable = new HashMap();

    public Dictionary(String des) {
    }

    public void addWordList(String filename) {
        try {
            InputStream s = this.getClass().getResourceAsStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(s));
            String nextline = br.readLine();
            while (nextline != null) {
                if (nextline.charAt(0) == '#') {
                    nextline = br.readLine();
                    continue;
                }
                String[] wordandscore = nextline.split(SCORE_DELIMITER);
                String nextword = wordandscore[0];
                int score = DEFAULT_SCORE;
                if (wordandscore.length > 1) {
                    score = Integer.parseInt(wordandscore[1]);
                }
                this.addWord(nextword, score);
                nextline = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("No such file.");
        }
        catch (IOException e) {
            System.out.println("File error.");
        }
    }

    public void addWord(String word, int score) {
        word = word.toLowerCase();
        Node curr = this.root;
        int i = 0;
        while (i < word.length()) {
            char ch = word.charAt(i);
            Node next = curr.edges.get(Character.valueOf(ch));
            if (next == null) {
                next = new Node(curr, ch, i, false, score);
                curr.edges.put(Character.valueOf(ch), next);
            }
            curr = next;
            ++i;
        }
        curr.isWord = true;
    }

    public int getWordScore(String query) {
        ArrayList<FillOption> res = this.lookup(query);
        if (res.size() == 0) {
            return DEFAULT_SCORE;
        }
        return res.get(0).getWordScore();
    }

    public ArrayList<FillOption> lookup(String query) {
        ArrayList<FillOption> matches = new ArrayList<FillOption>();
        if (query == "") {
            return matches;
        }
        this.lookup(query.toLowerCase(), this.root, matches);
        matches.sort(FillOptionCompare.getInstance());
        return matches;
    }

    public int countWords(String query) {
        Integer memoLookup = this.countWordsMemoTable.get(query.toLowerCase());
        if (memoLookup == null) {
            int size = this.lookup(query).size();
            this.countWordsMemoTable.put(query, size);
            return size;
        }
        return memoLookup;
    }

    public void lookup(String query, Node n, ArrayList<FillOption> matches) {
        if (n.depth == query.length() - 1) {
            if (n.isWord) {
                matches.add(0, n.getFillOption());
            }
            return;
        }
        char nextChar = query.charAt(n.depth + 1);
        if (nextChar == ' ') {
            for (Node k : n.edges.values()) {
                this.lookup(query, k, matches);
            }
        } else {
            Node k = n.edges.get(Character.valueOf(nextChar));
            if (k != null) {
                this.lookup(query, k, matches);
            }
        }
    }
}

