/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CrosswordFile {
    private Grid g;
    private ClueList clues;

    public CrosswordFile(Grid grid, ClueList clues) {
        this.g = grid;
        this.clues = clues;
    }

    public CrosswordFile(File f) {
        try {
            this.loadIpuz(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadIpuz(File f) throws IOException {
        JSONArray pair;
        FileReader reader = new FileReader(f);
        JSONTokener tokener = new JSONTokener(reader);
        JSONObject obj = new JSONObject(tokener);
        int dim = obj.getJSONObject("dimensions").getInt("width");
        this.g = new Grid(dim);
        int row = 0;
        while (row < dim) {
            int col = 0;
            while (col < dim) {
                String cell = obj.getJSONArray("solution").getJSONArray(row).getString(col);
                this.g.setChar(row, col, cell.charAt(0));
                ++col;
            }
            ++row;
        }
        this.clues = new ClueList(this.g);
        JSONObject savedClues = obj.getJSONObject("clues");
        JSONArray acrossClues = savedClues.getJSONArray("Across");
        JSONArray downClues = savedClues.getJSONArray("Down");
        int k = 0;
        while (k < acrossClues.length()) {
            pair = acrossClues.getJSONArray(k);
            this.clues.setHint(pair.getInt(0), true, pair.getString(1));
            ++k;
        }
        k = 0;
        while (k < downClues.length()) {
            pair = downClues.getJSONArray(k);
            this.clues.setHint(pair.getInt(0), false, pair.getString(1));
            ++k;
        }
        reader.close();
    }

    public void saveIpuz(File f) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put("version", "http://ipuz.org/v2");
        obj.put("kind", new JSONArray().put("http://ipuz.org/crossword#1"));
        int dim = this.g.getDim();
        obj.put("dimensions", new JSONObject().put("width", dim).put("height", dim));
        JSONArray soln = new JSONArray();
        int row = 0;
        while (row < dim) {
            JSONArray jsonRow = new JSONArray();
            int col = 0;
            while (col < dim) {
                jsonRow.put(Character.toString(this.g.getChar(row, col)));
                ++col;
            }
            soln.put(jsonRow);
            ++row;
        }
        obj.put("solution", soln);
        JSONArray acrossClues = new JSONArray();
        JSONArray downClues = new JSONArray();
        int k = 0;
        while (k < this.clues.size()) {
            JSONArray entry = new JSONArray();
            entry.put(this.clues.getNumber(k)).put(this.clues.getHint(k));
            if (this.clues.isAcross(k)) {
                acrossClues.put(entry);
            } else {
                downClues.put(entry);
            }
            ++k;
        }
        obj.put("clues", new JSONObject().put("Across", acrossClues).put("Down", downClues));
        FileWriter writer = new FileWriter(f);
        writer.write(obj.toString());
        writer.close();
    }

    public Grid getGrid() {
        return this.g;
    }

    public ClueList getClueList() {
        return this.clues;
    }
}

